/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.definitions;

public final class MathVariantMap {
    private static final int MIN_CODEPOINT = 32;
    private static final int MAX_CODEPOINT = 128;
    private final String mathVariantName;
    private final char[] accentByCodePoint;

    public MathVariantMap(String mathVariantName, char[] accentData) {
        this.mathVariantName = mathVariantName;
        this.accentByCodePoint = new char[96];
        int i = 0;
        while (i < accentData.length) {
            char ascii = accentData[i++];
            char accented = accentData[i++];
            int index2 = this.charToIndex(ascii);
            if (index2 == -1) continue;
            this.accentByCodePoint[index2] = accented;
        }
    }

    public String getMathVariantName() {
        return this.mathVariantName;
    }

    public char getAccentedChar(char c) {
        int index2 = this.charToIndex(c);
        return index2 != -1 ? this.accentByCodePoint[index2] : (char)'\u0000';
    }

    private int charToIndex(char c) {
        int index2 = c - 32;
        return index2 >= 0 && index2 < 128 ? index2 : -1;
    }
}

