/*
 * Decompiled with CFR 0.152.
 */
package org.blackquill.main;

import java.io.File;
import java.io.PrintWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blackquill.engine.BQParser;
import org.blackquill.engine.HTMLMap;
import org.blackquill.io.FileIO$;
import org.blackquill.main.BlackQuill$Switches$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class BlackQuill$ {
    public static final BlackQuill$ MODULE$;
    private final Log org$blackquill$main$BlackQuill$$log;
    private final String VERSION;
    private final String lastDate;
    private final String wiki;
    private final String syntax;
    private final String philosophy;
    private final String options;
    private final String description;

    static {
        new BlackQuill$();
    }

    public Log org$blackquill$main$BlackQuill$$log() {
        return this.org$blackquill$main$BlackQuill$$log;
    }

    public String VERSION() {
        return this.VERSION;
    }

    public String lastDate() {
        return this.lastDate;
    }

    public String wiki() {
        return this.wiki;
    }

    public String syntax() {
        return this.syntax;
    }

    public String philosophy() {
        return this.philosophy;
    }

    public String options() {
        return this.options;
    }

    public String description() {
        return this.description;
    }

    public void main(String[] args) {
        Regex sufRegex = new StringOps(Predef$.MODULE$.augmentString("\\.(md|markdown|txt|bq|blackquill)$$")).r();
        long start = System.currentTimeMillis();
        Iterator<String> it = Predef$.MODULE$.refArrayOps((Object[])args).iterator();
        it.foreach(new Serializable(sufRegex, it){
            public static final long serialVersionUID = 0L;
            private final Regex sufRegex$1;
            private final Iterator it$1;

            /*
             * Enabled aggressive block sorting
             */
            public final void apply(String elem2) {
                BlackQuill$.MODULE$.org$blackquill$main$BlackQuill$$log().debug(new StringBuilder().append((Object)"=>").append((Object)elem2.toString()).toString());
                if (elem2.startsWith("--")) {
                    String string2 = elem2.toString();
                    String string3 = string2;
                    if ("--force".equals(string3)) {
                        String x2 = string2;
                        BlackQuill$Switches$.MODULE$.setForce(true);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    String string4 = string2;
                    if ("--stdout".equals(string4)) {
                        String x3 = string2;
                        BlackQuill$Switches$.MODULE$.setStdout(true);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    String string5 = string2;
                    if ("--enc".equals(string5)) {
                        String x4 = string2;
                        BlackQuill$Switches$.MODULE$.setEncoding(true, ((String)this.it$1.next()).toString());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    String string6 = string2;
                    if ("--output".equals(string6)) {
                        String x5 = string2;
                        BlackQuill$Switches$.MODULE$.setOutput(true, ((String)this.it$1.next()).toString());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    String string7 = string2;
                    if ("--verbose".equals(string7)) {
                        String x6 = string2;
                        BlackQuill$Switches$.MODULE$.setVerbose(true);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    String string8 = string2;
                    if ("--version".equals(string8)) {
                        String x7 = string2;
                        BlackQuill$.MODULE$.org$blackquill$main$BlackQuill$$log().info(new StringBuilder().append((Object)"BlackQuill Version").append((Object)BlackQuill$.MODULE$.VERSION()).append((Object)" updated at ").append((Object)BlackQuill$.MODULE$.lastDate()).toString());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    String string9 = string2;
                    if ("--help".equals(string9)) {
                        String x8 = string2;
                        BlackQuill$.MODULE$.org$blackquill$main$BlackQuill$$log().info(BlackQuill$.MODULE$.description());
                        throw Predef$.MODULE$.exit();
                    }
                    BlackQuill$.MODULE$.org$blackquill$main$BlackQuill$$log().warn(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wrong switch is found. ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{elem2})));
                    throw Predef$.MODULE$.exit();
                }
                if (elem2.startsWith("-")) {
                    new StringOps(Predef$.MODULE$.augmentString(elem2)).foreach(new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(char e) {
                            char c = e;
                            switch (c) {
                                default: {
                                    BlackQuill$.MODULE$.org$blackquill$main$BlackQuill$$log().warn("Wrong Switch is found.");
                                    throw Predef$.MODULE$.exit();
                                }
                                case 'v': {
                                    BlackQuill$Switches$.MODULE$.setVerbose(true);
                                    break;
                                }
                                case 's': {
                                    BlackQuill$Switches$.MODULE$.setStdout(true);
                                    break;
                                }
                                case 'f': {
                                    BlackQuill$Switches$.MODULE$.setForce(true);
                                    break;
                                }
                                case '-': {
                                    Predef$.MODULE$.print(BoxedUnit.UNIT);
                                }
                            }
                        }
                    });
                    return;
                }
                String string10 = elem2;
                String string11 = "org.blackquill.main";
                if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                    Predef$.MODULE$.println();
                    return;
                }
                Option<Regex.Match> option = this.sufRegex$1.findFirstMatchIn(elem2.toString());
                None$ none$ = None$.MODULE$;
                if (!(option != null ? !option.equals(none$) : none$ != null)) {
                    BlackQuill$.MODULE$.org$blackquill$main$BlackQuill$$log().warn("inputfile suffix is wrong. => .md|.markdown|.txt|.bq|.blackquill");
                    return;
                }
                BlackQuill$Switches$.MODULE$.setInputfile(elem2.toString());
            }
            {
                this.sufRegex$1 = sufRegex$1;
                this.it$1 = it$1;
            }
        });
        FileIO$ fileHandler = FileIO$.MODULE$;
        BlackQuill$Switches$.MODULE$.outputFile_$eq(sufRegex.replaceAllIn((CharSequence)BlackQuill$Switches$.MODULE$.getInputfile(), ".html"));
        File iCheck = new File(BlackQuill$Switches$.MODULE$.getInputfile());
        File oCheck = new File(BlackQuill$Switches$.MODULE$.outputFile());
        if (!BlackQuill$Switches$.MODULE$.getForce() && oCheck.exists() && oCheck.lastModified() >= iCheck.lastModified()) {
            this.org$blackquill$main$BlackQuill$$log().warn("The MarkDown file is not changed. (see also --help)");
        } else {
            List<String> text2 = fileHandler.openMarkdownFromFile(BlackQuill$Switches$.MODULE$.getInputfile(), BlackQuill$Switches$.MODULE$.getEncoding());
            List<String> output = this.blackquill(new HTMLMap().specialCharConvert(text2));
            if (BlackQuill$Switches$.MODULE$.getVerbose()) {
                this.org$blackquill$main$BlackQuill$$log().info(new StringBuilder().append((Object)"generate HTML ").append(BoxesRunTime.boxToLong(System.currentTimeMillis() - start)).append((Object)" msec").toString());
            }
            PrintWriter out = BlackQuill$Switches$.MODULE$.getStdout() ? new PrintWriter(System.err) : (BlackQuill$Switches$.MODULE$.getOutput() ? new PrintWriter(new StringBuilder().append((Object)BlackQuill$Switches$.MODULE$.getOutputDir()).append((Object)BlackQuill$Switches$.MODULE$.outputFile()).toString(), BlackQuill$Switches$.MODULE$.getEncoding()) : new PrintWriter(new StringBuilder().append((Object)BlackQuill$Switches$.MODULE$.dirName()).append((Object)BlackQuill$Switches$.MODULE$.outputFile()).toString(), BlackQuill$Switches$.MODULE$.getEncoding()));
            output.foreach(new Serializable(out){
                public static final long serialVersionUID = 0L;
                private final PrintWriter out$1;

                public final void apply(String x$1) {
                    this.out$1.print(x$1);
                }
                {
                    this.out$1 = out$1;
                }
            });
            out.close();
            if (BlackQuill$Switches$.MODULE$.getVerbose()) {
                this.org$blackquill$main$BlackQuill$$log().info(new StringBuilder().append(System.currentTimeMillis() - start).append((Object)" msec").toString());
                String chkdStr = oCheck.length() > 0x40000000L ? new StringBuilder().append(oCheck.length() / 0x40000000L).append((Object)" GB").toString() : (oCheck.length() > 0x100000L ? new StringBuilder().append(oCheck.length() / 0x100000L).append((Object)" MB").toString() : (oCheck.length() > 1024L ? new StringBuilder().append(oCheck.length() / 1024L).append((Object)" KB").toString() : new StringBuilder().append(oCheck.length()).append((Object)" B").toString()));
                this.org$blackquill$main$BlackQuill$$log().info(new StringBuilder().append((Object)oCheck.getName()).append((Object)" => ").append((Object)chkdStr).toString());
            }
        }
    }

    public List<String> blackquill(List<String> lines2) {
        long start = System.currentTimeMillis();
        String str = new HTMLMap().htmlTAGFilter(lines2.mkString("\\,"));
        if (BlackQuill$Switches$.MODULE$.getVerbose()) {
            this.org$blackquill$main$BlackQuill$$log().info(new StringBuilder().append((Object)"TAGFiltered ").append(BoxesRunTime.boxToLong(System.currentTimeMillis() - start)).append((Object)" msec").toString());
        }
        this.org$blackquill$main$BlackQuill$$log().debug(str);
        String HTML = new BQParser().toHTML(str);
        if (BlackQuill$Switches$.MODULE$.getVerbose()) {
            this.org$blackquill$main$BlackQuill$$log().info(new StringBuilder().append((Object)"toHTML ").append(BoxesRunTime.boxToLong(System.currentTimeMillis() - start)).append((Object)" msec").toString());
        }
        this.org$blackquill$main$BlackQuill$$log().debug(HTML);
        return Predef$.MODULE$.refArrayOps((Object[])HTML.split("\\,")).toList();
    }

    private BlackQuill$() {
        MODULE$ = this;
        this.org$blackquill$main$BlackQuill$$log = LogFactory.getLog(this.getClass());
        this.VERSION = "0.1.6";
        this.lastDate = "Augus 15 2013";
        this.wiki = "https://www.setminami.net/BlackQuill/";
        this.syntax = "index.html#Syntax";
        this.philosophy = "index.html#Philosophy";
        this.options = "--force|-f : Force conversion. BQ ignore timestamps of markdown files.\n--stdout|-s :BQ outputs document to STDOUT as HTML.\n--enc shift-jis|euc-jp|UTF-8|ASCII default input enc is UTF-8\n--output DIR|-o :BQ outputs HTML to under DIR\n--verbose|-v :output conversion processes verbosely \n--version :output version and so on.\n--help|-h :output usage descriptions\n...and  Markdown file's suffix is .md|.markdown|.txt|.bq|.BlackQuill\ne.g., BlackQuill --force foo.md";
        this.description = new StringBuilder().append((Object)"Welcome to BlackQuill.\nBQ switches=> \n").append((Object)this.options()).append((Object)"\nPlease see also... \n").append((Object)this.wiki()).append((Object)this.syntax()).append((Object)"\n").append((Object)this.wiki()).append((Object)this.philosophy()).append((Object)"\n").toString();
    }
}

