<?php
/***************************************************************************
 *                          block.BCGroupIfCategory.php
 *                            -------------------
 *   begin                : 2007/04/19
 *   author               : Tomomi Yamamoto
 *   copyright            : 
 ***************************************************************************/
/***************************************************************************
 *	条件文コンテナタグ：
 *　　BCGroupsリストタグ内で使用するタグ
 *　　カテゴリーがある場合に、囲まれた処理を実行する。
 *　使用方法
 *	　<[BCGroups]>
 *      <[BCGroupIfCategory]>
 *       //状態が有効の場合にこの部分が処理される。
 *      <[/BCGroupIfCategory]>
 *    <[/BCGroups]>
 ***************************************************************************/
function smarty_block_BCGroupIfCategory($params, $content, &$smarty, &$repeat)
{
	// $contentが未設定の場合は開始タグ
	if(is_null($content))	
	{	

		//*********************
		//「開始タグ」
		//*********************	
		
		// BCGroupsタグ内で使用する為、以下の配列に値が存在しない場合は、
		// タグ外での使用とみなし、処理を終了する。
		if(!isset($smarty->_tpl_vars['BCGroups']['CategoryCount']))
		{
			$repeat = false;
			return;
		}

	}
	else
	{
		// エントリー数をチェック
		if($smarty->_tpl_vars['BCGroups']['CategoryCount'] > 0)
		{
			// エントリーあり
			$rtn = $content;
		}
		else
		{
			// エントリーなし
			$rtn = $smarty->_tpl_vars['BCElse'];
		}
		// 初期化
		$repeat = false;
		return $rtn;
	
	}
	
}
?>