<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		BitcubeInstall.php
 * @brief		bitcubeインストール
 * @date		2007.03.15
 */

// インストーラモード確認
if((isset($_POST["InstallMode"])) && ($_POST["InstallMode"]) && (!file_exists("./user.config.php")))
	unset($_POST["InstallMode"]);
else
	exit;

// 各種ファイル読み込み
require_once("./config/config.php");
require_once(SYSTEM_PATH."common/function.inc.php");
require_once(LIBRARY_DIR."/adodb/adodb.inc.php");

// セッションクリア
session_start();
session_destroy();

// umask設定
umask(UMASK_VAL);

// メッセージDIVの初期ID
$message_div_id = "error";

// データがPOSTされた場合チェック処理実行
if($_POST)
{
	// mod_rewriteチェック
	ob_start();
	phpinfo(INFO_MODULES);
	$phpinfo = ob_get_contents();
	ob_end_clean();
	if(preg_match("/PHP Version 5/",$phpinfo))
		if(!preg_match("/mod_rewrite/",$phpinfo))
			$message_array[] = "Apacheモジュール「mod_rewrite」が使用できません。";
	
	// POST値チェック
	if($_POST["DB_NAME"] == "")
		$message_array[] = "データベース名を入力してください。";
	if($_POST["DB_PREFIX"] == "")
		$message_array[] = "DBプレフィックスを入力してください。";
	else if(!is_alphabet($_POST["DB_PREFIX"]))
		$message_array[] = "「".htmlspecialchars($_POST["DB_PREFIX"])."」はDBプレフィックスに使用できません。";
	
	// ディレクトリ・ファイルチェック
	if(!is_writable(ROOT_PATH))
		$message_array[] = "インストールディレクトリに書き込み権限がありません。";
	if(!is_writable(SYSTEM_PATH))
		$message_array[] = "「bc_manager」に書き込み権限がありません。";
	if((file_exists(ROOT_PATH.".htaccess")) && (!is_writable(ROOT_PATH.".htaccess")))
		$message_array[] = "htaccessファイルに書き込み権限がありません。";
	if((file_exists(SYSTEM_PATH."user.config.php")) && (!is_writable(SYSTEM_PATH."user.config.php")))
		$message_array[] = "ユーザ設定ファイルが生成できません。";
	
	// adodbインスタンス生成
	$db = NewADOConnection($_POST["DB_TYPE"]);
	@$db->Connect($_POST["DB_HOST"],$_POST["DB_USER"],$_POST["DB_PASS"],$_POST["DB_NAME"]);
	$db->SetFetchMode(ADODB_FETCH_ASSOC);
	if(!$db->IsConnected())
	{
		$message_array[] = "データベースに接続できませんでした。";
	}
	else
	{
		$existing_tables = $db->MetaTables("TABLES");
		if(!is_bool(array_search($_POST["DB_PREFIX"]."_account",$existing_tables)))
			$message_array[] = "「".htmlspecialchars($_POST["DB_PREFIX"])."_account」は既に存在します。";
		if(!is_bool(array_search($_POST["DB_PREFIX"]."_category",$existing_tables)))
			$message_array[] = "「".htmlspecialchars($_POST["DB_PREFIX"])."_category」は既に存在します。";
		if(!is_bool(array_search($_POST["DB_PREFIX"]."_entry",$existing_tables)))
			$message_array[] = "「".htmlspecialchars($_POST["DB_PREFIX"])."_entry」は既に存在します。";
		if(!is_bool(array_search($_POST["DB_PREFIX"]."_group",$existing_tables)))
			$message_array[] = "「".htmlspecialchars($_POST["DB_PREFIX"])."_group」は既に存在します。";
		if(!is_bool(array_search($_POST["DB_PREFIX"]."_template",$existing_tables)))
			$message_array[] = "「".htmlspecialchars($_POST["DB_PREFIX"])."_template」は既に存在します。";
		if(!is_bool(array_search($_POST["DB_PREFIX"]."_template_module",$existing_tables)))
			$message_array[] = "「".htmlspecialchars($_POST["DB_PREFIX"])."_template_module」は既に存在します。";
	}
}

// エラーが無い場合インストール処理実行
if(($_POST) && (!$message_array))
{
	// ディレクトリ生成
	mkdir(CACHE_DIR);
	mkdir(LOCK_DIR);
	mkdir(DATA_DIR);
	mkdir(LOG_DIR);
	
	$userconf  = "<?php\n";
	$userconf .= "// DB設定\n";
	$userconf .= "define(\"DB_TYPE\",\"".$_POST["DB_TYPE"]."\");\n";
	$userconf .= "define(\"DB_HOST\",\"".$_POST["DB_HOST"]."\");\n";
	$userconf .= "define(\"DB_USER\",\"".$_POST["DB_USER"]."\");\n";
	$userconf .= "define(\"DB_PASS\",\"".$_POST["DB_PASS"]."\");\n";
	$userconf .= "define(\"DB_NAME\",\"".$_POST["DB_NAME"]."\");\n";
	$userconf .= "define(\"DB_PREFIX\",\"".$_POST["DB_PREFIX"]."\");\n";
	$userconf .= "\n";
	$userconf .= "// bitlist設定\n";
	$userconf .= "define(\"BL_CATEGORY\",\"".$_POST["BL_CATEGORY"]."\");\n";
	$userconf .= "\n";
	$userconf .= "// テンプレート設定\n";
	$userconf .= "define(\"TEMPLATE\",\"default\");\n";
	$userconf .= "\n";
	$userconf .= "// 記事日付設定\n";
	$userconf .= "define(\"START_YEAR\",10);\n";
	$userconf .= "define(\"END_YEAR\",10);\n";
	
	// ファイル書き出し
	if(file_exists(ROOT_PATH.".htaccess"))
		system("cp -r \"".ROOT_PATH.".htaccess\" \"".ROOT_PATH.".bcbackuphtaccess\" ");
	
	$handle = fopen(SYSTEM_PATH."user.config.php","w");
	if(!fwrite($handle,$userconf))
	{
		$message_array[] = "設定ファイルの生成に失敗しました。";
		break;
	}
	fclose($handle);
	
	// テーブル生成
	$create_account_sql = "CREATE TABLE ".$_POST["DB_PREFIX"]."_account (account_code integer NOT NULL primary key,account_name text,account_pass text,is_delete integer);";
	$create_category_sql = "CREATE TABLE ".$_POST["DB_PREFIX"]."_category (category_code integer NOT NULL primary key,group_code integer,category_name text,category_order integer,is_delete integer);";
	$create_entry_sql = "CREATE TABLE ".$_POST["DB_PREFIX"]."_entry (entry_code integer NOT NULL primary key,group_code integer,category_code integer,entry_regist_date date,entry_modification_date date,entry_date date,entry_publish integer,entry_title text,entry_body text,entry_order integer,entry_page_view integer,is_delete integer);";
	$create_group_sql = "CREATE TABLE ".$_POST["DB_PREFIX"]."_group (group_code integer NOT NULL primary key,group_regist_date date,group_modification_date date,group_name text,group_meta_description text,group_meta_keyword text,group_dir_name text,group_upload_dir_name text,group_default_publish integer,group_summary_strings_num integer,group_rss_output_num integer,group_rss1_output integer,group_rss1_file_name text,group_rss2_output integer,group_rss2_file_name text,group_atom_output integer,group_atom_file_name text,group_rss_copyright text,group_rss_creator text,group_ping_other_sites text,is_delete integer);";
	$create_template_sql = "CREATE TABLE ".$_POST["DB_PREFIX"]."_template (group_code integer NOT NULL primary key,top_page_tmpl text,category_page_tmpl text,news_detail_tmpl text,rss1_tmpl text,rss2_tmpl text,atom_tmpl text,base_css_tmpl text,bitcube_css_tmpl text,bitcube_ie5win_tmpl text,is_delete integer);";
	$create_template_module_sql = "CREATE TABLE ".$_POST["DB_PREFIX"]."_template_module (module_code integer NOT NULL primary key,group_code integer,module_name text,module_file_name text,module_body text,is_delete integer);";
	
	$db->Execute($create_account_sql);
	$db->Execute($create_category_sql);
	$db->Execute($create_entry_sql);
	$db->Execute($create_group_sql);
	$db->Execute($create_template_sql);
	$db->Execute($create_template_module_sql);
	
	// 初期データ登録
	$record = array("account_code"=>1,"account_name"=>"admin","account_pass"=>md5("admin"),"is_delete"=>0);
	$db->AutoExecute($_POST["DB_PREFIX"]."_account",$record,"INSERT");
	
	$message_div_id = "message";
	$message_array[] = "インストールが完了しました。<br /><br />下記の情報にて<a href=\"./index.php\">ログイン</a>してください。<br />ユーザ名:「admin」<br />パスワード:「admin」";
}

?>
<html>
<head>
<title>bitcubeインストール</title>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta name="robots" content="noindex,nofollow,noarchive">
<meta name="googlebot" content="noindex,nofollow,noarchive">
<style type="text/css">
<!--
div#error,div#message{width:100%;padding-top:5px;padding-bottom:5px;padding-left:5px;font-size:x-small;}
div#error ul,div#message ul{margin:0px;}
div#error li,div#message li{padding:2px;list-style:none;}
div#error {border:1px solid #FF9999;background:#FFEEEE;}
div#message {border:1px solid #9999FF;background:#EEEEFF;}
-->
</style>
</head>
<body>
<?php if($message_array): ?>
<div id="<?php echo $message_div_id; ?>">
  <ul>
<?php
foreach($message_array as $message)
    echo "<li>$message</li>";
?>
  </ul>
</div>
<?php endif; ?>
<div style="margin:20px;">
  <div<?php if($message_div_id == "message"): ?> style="display:none;"<?php endif; ?>>
    <form method="post" action="./index.php" style="margin:0px;">
<?php
	$bitlist_category_options = file_get_contents(BITLIST."bitlist_category.xml");
?>
<?php if(strlen($bitlist_category_options) > 0): ?>
      業種選択<br />
      <select name="BL_CATEGORY">
<?php
	$p = xml_parser_create();
	xml_parse_into_struct($p,$bitlist_category_options,$vals,$index);
	xml_parser_free($p);
	foreach($index["CODE"] as $key => $value)
	{
		$option_code = $vals[$index["CODE"][$key]]["value"];
		$option_value = $vals[$index["VALUE"][$key]]["value"];
		if($_POST["BL_CATEGORY"] == $option_code)
			echo "<option value=\"".htmlspecialchars($option_code)."\" selected>".htmlspecialchars($option_value)."</option>";
		else
			echo "<option value=\"".htmlspecialchars($option_code)."\">".htmlspecialchars($option_value)."</option>";
	}
?>
        <option value="0"<?php if($_POST["BL_CATEGORY"] == "0"): ?> selected<?php endif; ?>>上記以外</option>
      </select><br />
<?php else: ?>
      <input type="hidden" name="BL_CATEGORY" value="0" />
<?php endif; ?>
      データベース設定<br />
      <select name="DB_TYPE">
        <option value="postgres"<?php if($_POST["DB_TYPE"] == "postgres"): ?> selected<?php endif; ?>>PostgreSQL</option>
        <option value="mysql"<?php if($_POST["DB_TYPE"] == "mysql"): ?> selected<?php endif; ?>>MySQL</option>
      </select><br />
      <input type="text" name="DB_HOST" value="<?php echo htmlspecialchars($_POST["DB_HOST"]); ?>" style="ime-mode:disabled" />:ホスト名<br />
      <input type="text" name="DB_USER" value="<?php echo htmlspecialchars($_POST["DB_USER"]); ?>" style="ime-mode:disabled" />:ユーザ名<br />
      <input type="text" name="DB_PASS" value="<?php echo htmlspecialchars($_POST["DB_PASS"]); ?>" style="ime-mode:disabled" />:パスワード<br />
      <input type="text" name="DB_NAME" value="<?php echo htmlspecialchars($_POST["DB_NAME"]); ?>" style="ime-mode:disabled" />:データベース名<br />
      <input type="text" name="DB_PREFIX" value="<?php echo htmlspecialchars($_POST["DB_PREFIX"]); ?>" style="ime-mode:disabled" />:DBプレフィックス<br />
      <input type="submit" value="インストール開始" onclick="return confirm('インストールを開始しますか？');" />
    </form>
  </div>
</div>
</body>
</html>
<?php exit; ?>