<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		init.php
 * @brief		共通初期化処理
 * @date		2006.12.14
 */

// 内部文字エンコーディング設定
if(!extension_loaded("mbstring"))
	require_once(LIBRARY_DIR."/mb-emulator/mb-emulator.php");

// umask設定
umask(UMASK_VAL);

// マジッククオートを無効にする
if(get_magic_quotes_gpc())
{
	if(isset($_POST))
		$_POST = stripslashes_deep($_POST);
	if(isset($_GET))
		$_GET = stripslashes_deep($_GET);
}

// Unicodeベンダ依存文字修正
array_walk_recursive($_POST,"unicode_fix");
array_walk_recursive($_GET,"unicode_fix");

// GETデータ調整
$intval_list = array();
array_push($intval_list,"mode","group_code","category_code","entry_code","page");
foreach($intval_list as $value)
	if($_GET[$value])
		$_GET[$value] = intval($_GET[$value]);

if(($_GET["mode"] == 1) || ($_GET["mode"] == 27))
{
	if($_GET["page"] > 0)
		$_SESSION["page"][$_GET["mode"]][$_GET["group_code"]] = $_GET["page"];
	else if(!$_SESSION["page"][$_GET["mode"]][$_GET["group_code"]])
		$_SESSION["page"][$_GET["mode"]][$_GET["group_code"]] = 1;
	
	if(!$_SESSION["per_page"][$_GET["mode"]][$_GET["group_code"]])
		$_SESSION["per_page"][$_GET["mode"]][$_GET["group_code"]] = 10;
}
