<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		TemplateModuleInputForm.class.php
 * @brief		モジュールテンプレート入力フォームクラス
 * @date		2007.01.24
 */

require_once(CLASS_DIR."/form/AbstractForm.class.php");

class TemplateModuleInputForm extends AbstractForm
{
	function setModuleName($module_name="")
	{
		$this->module_name = $module_name;
	}
	
	function setModuleFileName($module_file_name="")
	{
		$this->module_file_name = $module_file_name;
	}
	
	function check()
	{
		$error_array = array();
		if(!is_null($this->module_name))
			if(!strlen($this->module_name))
				$error_array["module_name"] = "テンプレート名を入力してください。";
		if(!is_null($this->module_file_name))
			if(!strlen($this->module_file_name))
				$error_array["module_file_name"] = "ファイル名を入力してください。";
		return $error_array;
	}
}
