<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		GroupInputForm.class.php
 * @brief		更新セット入力フォームクラス
 * @date		2006.12.15
 */

require_once(CLASS_DIR."/form/AbstractForm.class.php");
require_once(CLASS_DIR."/adodb/GroupManager.class.php");

class GroupInputForm extends AbstractForm
{
	function setGroupName($group_name)
	{
		$this->group_name = $group_name;
	}
	
	function setDirName($group_dir_name)
	{
		$this->group_dir_name = $group_dir_name;
	}
	
	function setDefaultPublish($default_publish)
	{
		$this->default_publish = $default_publish;
	}
	
	function setSummaryStringsNum($summary_strings_num)
	{
		$this->summary_strings_num = $summary_strings_num;
	}
	
	function setUploadDirName($group_upload_dir_name)
	{
		$this->group_upload_dir_name = $group_upload_dir_name;
	}
	
	function check()
	{
		$dao = new GroupManager();
		$error_array = array();
		if(!is_null($this->group_name))
			if(!strlen($this->group_name))
				$error_array["group_name"] = "更新セット名を入力してください。";
		if(!is_null($this->group_dir_name))
			if(!strlen($this->group_dir_name))
				$error_array["group_dir_name"] = "更新セットのURLを入力してください。";
			else if(strlen($this->group_dir_name) > 12)
				$error_array["group_dir_name"] = "更新セットのURLは12文字以内で入力してください。";
			else if(!is_dirname($this->group_dir_name))
				$error_array["group_dir_name"] = "更新セットのURLは半角英数字で入力してください。";
			else if($dao->findGroupDirName($this->group_dir_name,$dao->GetOne("select $dao->group.group_dir_name from $dao->group where $dao->group.group_code = ".$_GET["group_code"])))
				$error_array["group_dir_name"] = "既に存在する更新セットのURLです。";
		if(!is_null($this->default_publish))
			if(!strlen($this->default_publish))
				$error_array["default_publish"] = "記事登録後の状態（基本設定値）を入力してください。";
		if(!is_null($this->summary_strings_num))
			if(!strlen($this->summary_strings_num))
				$error_array["summary_strings_num"] = "概要に載せる文字数を入力してください。";
			else if(!is_num($this->summary_strings_num))
				$error_array["summary_strings_num"] = "概要に載せる文字数は半角数字で入力してください。";
		if(!is_null($this->group_upload_dir_name))
			if(!strlen($this->group_upload_dir_name))
				$error_array["group_upload_dir_name"] = "画像のURLを入力してください。";
			else if(strlen($this->group_upload_dir_name) > 12)
				$error_array["group_upload_dir_name"] = "画像のURLは12文字以内で入力してください。";
			else if((!is_dirname($this->group_upload_dir_name)) || (strlen($this->group_upload_dir_name) > 12))
				$error_array["group_upload_dir_name"] = "画像のURLは半角英数字で入力してください。";
		return $error_array;
	}
}
