/*
**  bifst_a.h
**  bif-c
**
**  Created by Joel Rees on 2009/07/25.
**  Copyright 2009 __Reiisi_Kenkyuu__. All rights reserved.
**
** Translated to C from BIFST/A, as mechanically as possible.
**
*/


#if !defined BIFST_A_H
#define BIFST_A_H


#include <stdio.h>	/* for FILE type */
#include <setjmp.h>	/* for COLD's jump buffer, coldBuffer */


#include "bifu_i.h"
#include "bif2_a.h"
#include "bif6_a.h"


/*
00000010 * Start up routines for BIF
00020 * BIF Copyright 1989 Joel Matthew Rees (see BIF/ASM)
00100 *
*/
/* 00105 ILIM	EQU $8000 memory
** This should be enought to actually run. 
** Eventually, this will be a command-line flag. 
** Anyway, this is an attempt to calculate the memory requirements 
** and lay out the memory map by the calculations.
** I need to figure out the magic numbers.
** Ultimately, this will evolve into separate allocations.
** Right now, I'm grabbing a block of RAM and allocating backwards, 
** the way I did it on the 6809.
*/
#define ILIM 0x10000L	/* Was the bottom half of memory in the Color Computer, 0x8000, but we need space. */
extern byte_t memoryImage[ ILIM ];	/* So I can FORGET like I did in BIF-6809. */

/* 00110 IBUFF	EQU ILIM-BCT*(BWID+4) */
/* My memory is that there are two counters or something in the disk buffers. erk! One word of sector count. */
#define BUFF_CTRL_WID	( 2 * sizeof (cell_u) )	/* Only actually need one. */
/* The first control word contains the dirty buffers flag. */
#define BUFF_DIRTY_FLAG	CELL_HIGH_BIT
#define IBUFF ( ILIM - BCT * ( BWID + BUFF_CTRL_WID ) )

/* 00120 IPAD	EQU IBUFF-TWID max */
#define IPAD ( IBUFF - TWID )

/* 00130 IHASH	EQU IPAD-34 */
/* I don't remember what the 34 is. Wait, max binary digits of a double, plus two characters? */
#define IHASH ( IPAD - 80 )	/* Numeric formatting buffer, I think. */

/* 00140 IWPAD	EQU IHASH-NLMASK-2 */
#define IWPAD ( IHASH - NameLength_k - 8 )	/* The word pad string parsing buffer. */

/* 00150 ITIB	EQU IWPAD-TWID */
#define ITIB ( IWPAD - TWID )	/* Base of terminal input buffer. */

/* 00160 IUSER	EQU ITIB-UEND */
#define IUSER ( ITIB - ( 4 * UEND ) )		/* Base of user structure. (4 tasks, just for fun?) */

#define	STACK_BUMPER_HOLE	2	/* and one more than the original, for good measure. */
#define CONTROL_STACK_SIZE	256	/* At least twice the original, since C is a bit bulky. */

/* 00170 IRP0	EQU IUSER-2 */
#define	IRP0 ( IUSER - STACK_BUMPER_HOLE * sizeof (cell_u) )	/* With the crash buffer hole. */

/* 00180 ISP0	EQU IRP0-258 */
#define ISP0 ( IRP0 - ( CONTROL_STACK_SIZE + STACK_BUMPER_HOLE ) * sizeof (cell_u) )	/* Again, crash buffer. */

/* The dictionary heap grows from the bottom up. 
*/


/* Boot-up initializations structure:

** Should this be an array?

** Also, taskrecord_s is not appropriate here. Must split it out.

*/

/* 00190 * dictionary below here */
/* 00400 * */
/* 00410 ORIG	EQU * initials for task 0, offsets */
/* ORIG was 256 bytes above the (DP) direct page allocation in my 6809 version.
** I don't have any direct page in the C version, and everything that was there is allocated 
** outside the memoryImage array.
** Essentially, everything in the direct page allocation was global. 
** I was thinking hard about UP, and about trying to use DP instead of UP, 
** but that really wasn't very workable in combination with putting XCOL et. al. in the direct page. 
** I might consider, later, making a register record in the bottom of the memoryImage, 
** but that will be when I have a better idea how to handle tying the dictionary together 
** for child processes.
**
** Ultimately, ORIG becomes an alias for the boot constants structure.
*/

typedef struct boot_constants_s 
{
/* 00420 	NOP 0 */
/* 00430 	JMP COLD 1 */
	icode_f	coldBootEntry;
/* 00440 	NOP 4 */
/* 00450 	JMP WARM 5 */
	icode_f	warmBootEntry;
/* 00460 	FDB $6809 cpu 8 */
	cell_u	cpuID;
/* 00470 	FDB 0 rev $0A */
	cell_u	versionID;
/* 00480 	FDB FORGET-CFAOFF CURRENT for COLD $0C */
	cell_u	initialCurrent;	/* lastDefined */
/* 00490 	FDB 8 backspace $0E */
	cell_u	terminalBackSpace;
/* 00500 	FDB IUSER task 0 user area $10 */
	cell_u	initialTaskBase;
/* 00510 	FDB ISP0 $12 */
	cell_u	initialParameterStackBase;	/* upside down */
/* 00520 	FDB IRP0 $14 */
	cell_u	initialReturnStackBase;	/* upside down */
/* 00530 	FDB ITIB $16 */
	cell_u	initialTerminalInputBuffer;
/* 00540 	FDB NLMASK not used $18 */
	cell_u	initialReserved_NameLengthMask;
/* 00550 	FDB 1 WARNING $1A */
	cell_u	initialDiskOnLine;
/* 00560 	FDB FOLLOW-1 FENCE for COLD $1C */
	cell_u	initialForgetFence;	/* This will start at the bottom of the useable memory image. */
/* 00570 	FDB FOLLOW DP for COLD $1E */
	cell_u	initialDictionaryAllocationPointer;
/* 00580 	FDB BIF+2 defs root $20 */
	cell_u	initialDefinitionContextRoot;
/* 00590 	FDB IPAD $22 */
	cell_u	initialNumericConversionScratchPad;
/* 00600 	FDB IWPAD $24 */
	cell_u	initialWordBufferPointer;
/* 00610 	FDB 32 terminal columns $26 */
	cell_u	initialTerminalColumns;	/* Eventually, get this from the system. */
/* 00620 	FDB IBUFF $28 */
	cell_u	initialDiskBuffers;
/* 00630 	FDB ILIM $2A */
	cell_u	initialLimitOfBufferRAM;
/* Since we want to track the last built-in, and FENCE now points elsewhere: */
	cell_u	initialTailFence;
/* Mostly whether EXPECT echos or not: */
	cell_u	initialTerminalEcho;
} boot_constants_s;
/* 01000 * */
extern boot_constants_s	ORIG;


extern int break_pressed( void );	/* For querying BREAK key status, reset. */


extern FILE * standardInput;
extern FILE * standardOutput;
extern FILE * standardError;
extern FILE * standardLog;


/*
01010 	FCC 'COLD'
01020 	FCB 4
01030 	FCB MFORE
01040 	FDB 0
01050 	FDB BIF+2
01060 	FDB 0
01070 	FDB 0
01080 COLD	LEAY DOREGS,PCR
01090 	EXG PC,Y call
01100 	SETDP VDP
01110 	CLR $71 for BASIC reset
01120 	LDD -4,Y
01130 	STD UCURR,X
01140 	LDD $0C,Y
01150 	STD UFENCE,X
01160 	LDD $0E,Y
01170 	STD UDP,X
01180 	LDD $10,Y
01190 	STD UROOT,X
01200 	STD UDROOT,X
01210 	PSHU D     Initial vocabularies
01220 	BSR PRUNE  must ALL be PRUNEd!
01230 	LDD #EDITOR+2
01240 	PSHU D
01250 	BSR PRUNE
01260 	LDD #ASMBLR+2
01270 	PSHU D
01280 	BSR PRUNE
01290 	JMP WARM+5
01300 	SETDP 0
01310 * Watch stack (vocabulary) depth!
01315 	SETDP VDP
01320 PRUNE	PSHS D,X,Y
01330 	LDY <UP
01340 	LDX ,U++ vocab
01344 	BEQ PRUNEX+2
01348 	LDD ,X root
01352 	BEQ PRUNEX+2
01356 	CMPD UFENCE,Y
01360 	BLS PRUNSK
01364 	LDD #0
01368 	STD ,X
01372 	BRA PRUNEX+2
01376 PRUNSK	TFR D,X
01380 	LDD #0
01386 	PSHS D mark
01390 PRUNL	LDD RTOFF,X
01400 	BEQ PRUNLF
01410 	CMPD UFENCE,Y
01420 	BLS PRUNLF-2
01430 	LDD #0 make leaf
01440 	STD RTOFF,X
01450 	BRA PRUNLF
01460 	PSHS D for later
01470 PRUNLF	LDD LFTOFF,X
01480 	BEQ PRUNEX-2
01490 	CMPD UFENCE,Y
01500 	BHI PRUNL0
01510 	TFR D,X go left
01520 	BRA PRUNL
01530 PRUNL0	LDD #0 make leaf
01540 	STD LFTOFF,X
01550 	LDX ,S++ go right?
01560 PRUNEX	BNE PRUNL
01570 	PULS D,X,Y,PC
01580 	SETDP 0
01590 *
02000 	SETDP 0
02010 DOREGS	LDS #IRP0
02020 	PSHS CC save
02030 	ORCC #$50 mask ints
02040 	PSHS Y return adr
02050 	LDD #DPAGE
02060 	TFR A,DP
02070 	SETDP VDP
02080 	LDY #ORIG+$10
02090 	LDX ,Y
02100 	STX <UP
02110 	LDU #ISP0
02120 	LDD #0
02130 	STD >0 trap [NULL]s
02140 	RTS
02150 	SETDP 0
02160 *
*/
extern jmp_buf coldBuffer;
extern definition_header_s hCOLD;
extern void COLD(void);
extern void xCOLD(void);


extern definition_header_s hBYE;
extern void BYE(void);


/*
02230 	FCC 'WARM'
02240 	FCB 4
02250 	FCB MFORE
02260 	FDB COLD-CFAOFF
02270 	FDB BIF+2
02280 	FDB VLIST-CFAOFF
02290 	FDB WARN-CFAOFF
02300 WARM	LEAY <DOREGS,PCR
02310 	EXG PC,Y call
02320 	SETDP VDP
02360 	LDD 2,Y
02370 	STD US0,X
02380 	STD UCSP,X
02390 	LDD 4,Y
02400 	STD UR0,X
02410 	LDD -2,Y
02420 	STD UBS,X
02430 	LDD 6,Y
02440 	STD UTIB,X
02450 	LDD $0A,Y
02460 	STD UWARN,X
02470 	LEAY $10,Y
02480 	LDD 2,Y
02490 	STD UPAD,X
02500 	STD UHLD,X
02510 	LDD 4,Y
02520 	STD UWP,X
02530 	LDD 6,Y
02540 	STD UCOLUM,X
02550 	LDD 8,Y
02560 	STD UFIRST,X
02570 	STD UUSE,X
02580 	STD UPREV,X
02590 	LDD $0A,Y
02600 	STD ULIMIT,X
02610 	LDD #16
02620 	STD UBASE,X
02630 	LDD #0
02640 	STD [UR0,X] hole
02650 	STD [US0,X] hole
02660 	LDA #(UEND-UIN)
02670 	LEAY UIN,X
02680 WARMLY	STB ,Y+
02690 	DECA
02700 	BNE WARMLY
02740 	PULS CC
02745 	ANDCC #$EF enable IRQ (disc)
02750 	DOCOL
02760 	FDB EMTBUF
02770 	FDB ABORT
02780 	SETDP 0
02890 *
*/
extern definition_header_s hWARM;
extern void WARM(void);


#if defined DEBUGGING && DEBUGGING >= 2 && DEBUGGING < 0x10


extern definition_header_s hDUMMYVOC;

extern definition_header_s hDUMMYCOL;

extern definition_header_s hDUMMYCOL1;

extern definition_header_s hDUMMYFIND;

extern definition_header_s hDUMMYAVAR;

extern definition_header_s hDUMMYACON;

extern definition_header_s hSPARE1;

#endif /* defined DEBUGGING && DEBUGGING >= 2 && DEBUGGING < 0x10 */


#endif /* !defined BIFST_A_H */
