/*
**  bif6_a.c
**  bif-c
**
**  Created by Joel Rees on 2009/07/25.
**  Copyright 2009 __Reiisi_Kenkyuu__. All rights reserved.
**
** Translated to C from BIF6/A, as mechanically as possible.
*/


#include <limits.h>
#include <stddef.h>

#include "bif_m.h"

#include "bif7b_a.h"	/* To link into the BIF vocabulary. */
#include "bif1_a.h"	/* for SEMIS */

#include "bif6_a.h"


/*
00010 * Include file for BIF
00020 * BIF Copyright 1989 Joel Matthew Rees (see BIF/ASM)
00030 *
01000 	FCC '(NUMBER)'
01010 	FCB 8
01020 	FCB MFORE
01030 	FDB QARROW-CFAOFF
01040 	FDB BIF+2
01050 	FDB 0
01060 	FDB PREF-CFAOFF
*/
static character_t sINUMB[] = "\x8" "(NUMBER)";
definition_header_s hINUMB = 
{	{ (natural_t) sINUMB },
	{ 0 },
	{ (natural_t) &hQARROW },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ (natural_t) &hPREF },
	{ (natural_t) INUMB }
};
/*
01070 INUMB	PSHS Y	see fig-FORTH model
01080 	PULU Y adr
01085 	LDX <UP
01090 INUMBL	LDB ,Y+ ch
01092 	CLRA
01094 	PSHU D
01096 	LDD UBASE,X
01100 	PSHU D
01110 	DOCOL
01120 	FDB DIGIT
01130 	FDB ZBR
01140 	FDB INUMBE-*-2
01150 	FDB SWAP accm ms word
01160 	FDB BASE
01180 	FDB FETCH
01190 	FDB USTAR shift in base
01200 	FDB DROP ls word is digit
01210 	FDB ROT accm ls word
01220 	FDB BASE
01230 	FDB FETCH
01240 	FDB USTAR shift in base
01250 	FDB DADD accumulate
01260 	FDB XMACH adjust dpl
01270 	LDX <UP
01280 	LDD UDPL,X
01290 	BMI INUMBL
01300 	ADDD #1
01310 	STD UDPL,X
01320 	BRA INUMBL
01330 INUMBE	FDB XMACH
01340 	LEAY -1,Y back up
01350 	PSHU Y adr
01355 	PULS Y
01360 	NEXT
01390 *
*/
void INUMB( void )
{	/* stack: accm string */
	character_t * parse = ( * SP++ ).chString;
#if !defined MANUFACTURED_DOUBLE
	/* Actual accm in local variable. */
#	if !defined LOW_C_CELL_FIRST	/* FORTH CPU CELL order for doubles. */
	dblnatural_t accm = * ( (dblnatural_t *) (byte_t *) SP );
#	else /* defined LOW_C_CELL_FIRST */
	dblnatural_t accm = ( (dblnatural_t) SP[ 0 ].integer << BITSPERCELL ) | SP[ 1 ].integer;
#	endif /* !defined LOW_C_CELL_FIRST */
#endif /* !defined MANUFACTURED_DOUBLE */

	for ( ;; )
	{
#if defined MANUFACTURED_DOUBLE
		natural_t digit;
		natural_t accmHi;	/* Actual accm on stack. */
#endif /* defined MANUFACTURED_DOUBLE */

		( * --SP ).integer = * parse++;
		( * --SP ).integer = UP.task->numericBase.integer;
		DIGIT();
		if ( ( * SP++ ).integer == 0 )
		{	break;	/* Nothing under the false flag. */
		}

#if !defined MANUFACTURED_DOUBLE
		accm *= UP.task->numericBase.integer;
		accm += ( * SP++ ).integer;	/* The digit under the true flag. */
#else /* defined MANUFACTURED_DOUBLE */
		digit = SP[ 0 ].integer;
		SP[ 0 ].integer = UP.task->numericBase.integer;
		USTAR();	/* accumlator most significant CELL, double result */
		++SP;
		accmHi = SP[ 0 ].integer;
		SP[ 0 ].integer = UP.task->numericBase.integer;
		USTAR();
		( * --SP ).integer = digit;	/* Combine, so you can do it with one DADD(). */
		( * --SP ).integer = accmHi;
		DADD();	/* Two birds with one stone? */
#endif /* !defined MANUFACTURED_DOUBLE */

		if ( UP.task->decimalPoint.sinteger >= 0 )
		{	UP.task->decimalPoint.sinteger += 1;
		}
	}
	( * --SP ).chString = parse - 1;
#if !defined MANUFACTURED_DOUBLE
#	if !defined LOW_C_CELL_FIRST	/* FORTH CPU CELL order for doubles. */
	* ( (dblnatural_t *) (byte_t *) ( SP + 1 ) ) = accm;
#	else /* defined LOW_C_CELL_FIRST */
	SP[ 2 ].integer = (natural_t) accm;
	SP[ 1 ].integer = (natural_t) ( accm >> BITSPERCELL );
#	endif /* !defined LOW_C_CELL_FIRST */
#endif /* !defined MANUFACTURED_DOUBLE */
#if defined DBG_NUMBER_PARSE
#	if !defined MANUFACTURED_DOUBLE
	fprintf( standardError, "(number parsed): (|%llX|=|%llu|): dpl=%ld\n", 
	         ( * ( (dblnatural_t *) (byte_t *) SP + 1 ) ), ( * ( (dblnatural_t *) (byte_t *) SP + 1 ) ),
	         (long) UP.task->decimalPoint.sinteger );
#	else /* defined MANUFACTURED_DOUBLE */
	fprintf( standardError, "(number parsed): (|%lX|%lX|=|%lu|%lu|): dpl=%ld\n", 
	         SP[ 1 ].integer, SP[ 2 ].integer, SP[ 1 ].integer, SP[ 2 ].integer, 
	         (long) UP.task->decimalPoint.sinteger );
#	endif /* !defined MANUFACTURED_DOUBLE */
#endif
}


/*
01400 	FCC 'NUMBER'
01410 	FCB 6
01420 	FCB MFORE
01430 	FDB INUMB-CFAOFF
01440 	FDB BIF+2
01450 	FDB MIN-CFAOFF
01460 	FDB OVER-CFAOFF
*/
static character_t sNUMBER[] = "\x6" "NUMBER";
definition_header_s hNUMBER = 
{	{ (natural_t) sNUMBER },
	{ 0 },
	{ (natural_t) &hINUMB },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hMIN },
	{ (natural_t) &hOVER },
	{ (natural_t) NUMBER }
};
/*
01470 NUMBER PULU X
01475 	LEAX 1,X skip ct
01480 	LDB ,X <0?
01490 	SUBB #'-
01500 	BNE *+4
01510 	LEAX 1,X
01520 	CLRA
01530 	PSHU D
01540 	CLRB
01550 	PSHU D double 0
01560 	PSHU D
01570 	PSHU X adr
01580 	LDD #-1 clear DPL
01590 NUMBA	LDX <UP
01600 	STD UDPL,X
01610 	DOCOL
01620 	FDB INUMB
01630 	FDB XMACH
01640 	LDX ,U end ch
01650 	LDB ,X ascii NUL?
01660 	BEQ NUMBQ
01670 	CMPB #': double?
01680 	BEQ NUMBD
01690 	CMPB #'-
01700 	BLO NUMBE
01710 	CMPB #'/
01720 	BHI NUMBE
01730 NUMBD	LEAX 1,X past dec pt
01740 	STX ,U
01750 	LDD #0 set DPL
01760 	BRA NUMBA
01770 NUMBE	LDD #0
01780 	PSHU D
01790 	JMP ERROR
01800 NUMBQ	LEAU 2,U valid, drop
01810 	DOCOL
01830 	FDB ROT <0?
01840 	FDB TBR
01850 	FDB 2
01860 	FDB DMINUS
01870 	FDB SEMIS
01890 *
*/
void NUMBER( void )
{
	character_t * parse = ( * SP++ ).chString + 1;	/* Skip the count. */
	snatural_t signFlag = ( * parse ) - '-';
	if ( signFlag == 0 )	/* unary minus? */
	{	++parse;
	}
#if !defined MANUFACTURED_DOUBLE
	SP -= sizeof (dblnatural_t) / sizeof ( * SP );
	* ( (dblnatural_t *) ( (byte_t *) SP ) ) = 0LL;
#else /* defined MANUFACTURED_DOUBLE */
	SP -= 2;
	SP[ 0 ].integer = SP[ 1 ].sinteger = 0L;
#endif /* !defined MANUFACTURED_DOUBLE */
	( * --SP ).chString = parse;
	UP.task->decimalPoint.sinteger = -1;
	for ( ;; )	/* Actually, should only run once or twice. */
	{	natural_t ch;
		INUMB();
		parse = SP[ 0 ].chString;
		ch = * parse;
		if ( ch == '\0' )
		{	break;
		}
		/* I thought this would be cool. It's not. I'll fix it after I get it running. */
		if ( ( ch == ':' ) || ( ( ch >= '-' ) && ( ch <= '/' ) ) )
		{	SP[ 0 ].chString = ++parse;
			/* Remembers the last one seen. Not sure this is right, either. */
			UP.task->decimalPoint.sinteger = 0;
		}
		else
		{	/* This needs an explicit error message, too, something like "parse error", at least. */
			mERROR( 0L );
		}
	}
	SP++;	/* Don't need the parse point any more. */
	if ( signFlag == 0 )
	{	DMINUS();
	}
#if defined DBG_NUMBER_PARSE
#	if !defined MANUFACTURED_DOUBLE
	fprintf( standardError, "number parsed: |%llX|=|%llu|: dpl=%ld\n", 
	         ( * ( (dblnatural_t *) (byte_t *) SP ) ), ( * ( (dblnatural_t *) (byte_t *) SP ) ),
	         (long) UP.task->decimalPoint.sinteger );
#	else /* defined MANUFACTURED_DOUBLE */
	fprintf( standardError, "number parsed: |%lX|%lX|=|%lu|%lu|: dpl=%ld\n", 
	         SP[ 0 ].integer, SP[ 1 ].integer, SP[ 0 ].integer, SP[ 1 ].integer, 
	         (long) UP.task->decimalPoint.sinteger );
#	endif /* !defined MANUFACTURED_DOUBLE */
#endif
}


/*
01900 	FCC 'WORDPAD'
01910 	FCB 7
01920 	FCB MFORE
01930 	FDB NUMBER-CFAOFF
01940 	FDB BIF+2
01950 	FDB 0
01960 	FDB 0
*/
static character_t sWORDPD[] = "\x7" "WORDPAD";
definition_header_s hWORDPD = 
{	{ (natural_t) sWORDPD },
	{ 0 },
	{ (natural_t) &hNUMBER },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) XUCON },
	{	{ UWP }	}
};
/*
01970 WORDPD	DOUCON
01980 	FCB UWP
01990 *
02000 	FCC 'WORD'
02010 	FCB 4
02020 	FCB MFORE
02030 	FDB WORDPD-CFAOFF
02040 	FDB BIF+2
02050 	FDB WHILE-CFAOFF
02060 	FDB BCOMP-CFAOFF
*/
static character_t sWORD[] = "\x4" "WORD";
definition_header_s hWORD = 
{	{ (natural_t) sWORD },
	{ 0 },
	{ (natural_t) &hWORDPD },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ (natural_t) &hWORDPD },
	{ (natural_t) WORD }
};
/*
02070 WORD	PSHS Y
02075 	LDY <UP
02080 	LDD UBLK,Y terminal?
02090 	BEQ WORDK buffer
02100 	PSHU D
02110 	DOCOL
02120 	FDB BLOCK
02130 	FDB XMACH
02140 	PULU D
02150 	BRA *+4 UTIB < 16!
02160 WORDK	LDD UTIB,Y
02170 	ADDD UIN,Y parse at
02180 	PULU X ch
02190 	TFR D,Y save
02200 	PSHU X,Y (swap)
02205 	DOCOL
02210 	FDB ENCLOS
02215 	FDB XMACH
02220 	PSHS Y start at
02221 	LDD 2,U symbol at
02222 	SUBD ,S++ delimiter count
02223 	ADDD ,U length
02225 	LDX <UP
02226 	ADDD UIN,X
02227 	STD UIN,X update
02230 	PULU D length
02240 	CMPD #NLMASK
02250 	BLS *+5 clip
02260 	LDD #NLMASK
02270 	LDY UWP,X
02280 	STB ,Y+ count
02290 	CLR B,Y trailing NUL
02300 	PSHU D,Y dest & ct
02330 	PULS Y
02340 	DOCOL
02350 	FDB CMOVE copy
02360 	FDB SEMIS
02490 *
*/
void WORD( void )
{	natural_t delimiter = SP[ 0 ].integer;	/* Save it. */
	character_t * buffer;
	character_t * sourceMarker;
	character_t * destinationMarker;
	natural_t newOffset, length;
#if defined DBG_WORD_PARSE
	character_t * startParse;
/* dbg */ printf( "Starting WORD\n" );
#endif
	if ( UP.task->activeDiscBlock.integer != 0 )
	{	SP[ 0 ] = UP.task->activeDiscBlock;
		BLOCK();	/* Leaves the data address in the block. */
	}
	else
	{	SP[ 0 ] = UP.task->terminalInputBuffer;
	}
	buffer = SP[ 0 ].chString;
	SP[ 0 ].chString = buffer + UP.task->bufferInputOffset.integer;
#if defined DBG_WORD_PARSE
	startParse = SP[ 0 ].chString;
#endif
	( * --SP ).integer = delimiter;
	ENCLOS();	/* ENCLOSE ( buffer c --- s length ) */
	length = SP[ 0 ].integer;
	sourceMarker = SP[ 1 ].chString;
	newOffset = sourceMarker + length - buffer;	
	UP.task->bufferInputOffset.integer = newOffset;
	if ( length > NLMASK )
	{	length = NLMASK;	/* Clipping is not the most favored approach. */
	}
	destinationMarker = UP.task->wordBufferPointer.chString;
	( * destinationMarker++ ) = (character_t) length;
	destinationMarker[ length ] = '\0';	/* Seal it off with a trailing NUL. */
	SP[ 0 ].chString = destinationMarker;
	( * --SP ).integer = length;
	CMOVE();
#if defined DBG_WORD_PARSE
	fprintf( standardError, "from {%.20s}(%.20s), token parsed: (%lu){%.20s}, offset to %lu, copied: {%.20s}\n", 
			 buffer, startParse, (unsigned long) length, sourceMarker, 
			 (unsigned long) UP.task->bufferInputOffset.integer, destinationMarker );
#endif
}


/*
02500 	FCC 'BS'
02510 	FCB 2
02520 	FCB MFORE
02530 	FDB WORD-CFAOFF
02540 	FDB BIF+2
02550 	FDB BRANCH-CFAOFF
02560 	FDB 0
*/
static character_t sBS[] = "\x2" "BS";
definition_header_s hBS = 
{	{ (natural_t) sBS },
	{ 0 },
	{ (natural_t) &hWORD },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hBRANCH },
	{ 0 },
	{ (natural_t) XUCON },
	{	{ UBS }	}
};
/*
02570 BS	DOUCON
02580 	FCB UBS
02590 *
02600 	FCC 'EXPECT'
02610 	FCB 6
02620 	FCB MFORE
02630 	FDB BS-CFAOFF
02640 	FDB BIF+2
02650 	FDB ERROR-CFAOFF
02660 	FDB FILL-CFAOFF
*/
static character_t sEXPECT[] = "\x6" "EXPECT";
definition_header_s hEXPECT = 
{	{ (natural_t) sEXPECT },
	{ 0 },
	{ (natural_t) &hBS },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hERROR },
	{ (natural_t) &hFILL },
	{ (natural_t) EXPECT }
};
/*
02670 EXPECT	PSHS Y
02680 	LDD ,U count
02690 	LDY 2,U buffer
02700 	SUBD #1	for NUL
02710 	BLT EXPE0+2
02720 	BEQ EXPE0
02730 	LEAX D,Y
02740 	STX ,U limit
02750 EXPEL	DOCOL
02760 	FDB KEY
02770 	FDB XMACH
02780 	LDB 1,U
02790 	LDX <UP
02800 	CMPB UBS+1,X
02810 	BNE EXPECR
02820 	CMPY 4,U beginning?
02830 	BLS EXPEM0
02840 	LEAY -1,Y
02850 	BRA EXPEM
02860 EXPEM0	CLR 1,U to emit
02870 	BRA EXPEM
02880 EXPECR	CMPB #$0D
02890 	BNE EXPEPT
02900 	STY 2,U terminate
02910 	BRA EXPEM
02913 EXPEPT	CMPB #$20 printable?
02916 	BLO EXPEM0
02920 	STB ,Y+ store ch
02930 EXPEM	DOCOL
02940 	FDB EMIT
02950 	FDB XMACH
02960 	CMPY ,U
02970 	BLO EXPEL
02980 EXPE0	CLR ,Y NUL term
02990 	LEAU 4,U
03000 	PULS Y
03010 	NEXT
03090 *
*/
void EXPECT( void )
{
	snatural_t count = ( * SP++ ).sinteger - 1;
	character_t * buffer = ( * SP++ ).chString;
	character_t * bin = buffer;	/* input point */
	character_t * limit = buffer + count;
	if ( count < 0 )
	{	return;
	}
	* bin = '\0'; /* Terminate the buffer. */
	while ( bin < limit )
	{	natural_t ch;
		KEY();
		ch = SP[ 0 ].integer;
		if ( ( ch == UP.task->backSpaceConstant.integer ) && ( bin > buffer ) )
		{	--bin;
		}
		if ( ch == '\n' )	/* This should be in the per-USER table, too. */
		{	limit = bin;	/* End it. */
			* bin = (character_t) '\0';	/* Want to make sure it's delimited */
		}
		if ( ch >= ' ' )	/* It's tempting to use !isctl( ch ) */
		{	* bin++ = (character_t) ch;
		}
		SP[ 0 ].integer = (character_t) ch;
		if ( UP.task->terminalEcho.integer )
		{	EMIT();	/* ncurses! foiled again! (In lieu of using curses.) */
		}
		else
		{	++SP;	/* It's in the terminal input buffer. */
		}
	} 
}


/*
03600 TWID	EQU 128 width of a terminal line
03605 	FCC 'QUERY'
03610 	FCB 5
03620 	FCB MFORE
03630 	FDB EXPECT-CFAOFF
03640 	FDB BIF+2
03650 	FDB LOOP-CFAOFF
03660 	FDB SWAP-CFAOFF
*/
static character_t sQUERY[] = "\x5" "QUERY";
definition_header_s hQUERY = 
{	{ (natural_t) sQUERY },
	{ 0 },
	{ (natural_t) &hEXPECT },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hLOOP },
	{ (natural_t) &hSWAP },
	{ (natural_t) QUERY },
/*	{ (natural_t) XCOL },
	{
		{ (natural_t)	&hZERO	},
		{ (natural_t)	&hIN	},
		{ (natural_t)	&hSTORE	},
		{ (natural_t)	&hTIB	},
		{ (natural_t)	&hLIT	},	/ * Shouldn't this be a per-USER constant? * /
		{ TWID	},
		{ (natural_t)	&hEXPECT	},
		{ (natural_t)	&hSEMIS	}
	}
*/
};
/*
03670 QUERY	LDX <UP
03680 	LDD #0
03690 	STD UIN,X
03700 	LDD #TWID		// Shouldn't this be a per-USER constant?
03710 	LDX UTIB,X
03720 	PSHU D,X
03730 	DOCOL
03740 	FDB EXPECT
03750 	FDB SEMIS
03790 *
*/
void QUERY(void)
{	UP.task->bufferInputOffset.integer = 0;
	( * --SP ) = UP.task->terminalInputBuffer;
	( * --SP ).integer = TWID;
	EXPECT();
}


/*
03800 	FCB MIMM
03810 	FCB MFORE
03820 	FDB QUERY-CFAOFF
03830 	FDB BIF+2
03840 	FDB 0
03850 	FDB 0
*/
static character_t sNUBLK[] = "\x0" "";	/* NUL Superfluous, but will catch the eye of C fluent readers. */
definition_header_s hNUBLK = 
{	{ (natural_t) sNUBLK },
	{ MIMM },
	{ (natural_t) &hQUERY },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) NUBLK }
};
/*
03860 NUBLK	LDX <UP
03870 	LDD UBLK,X
03880 	BEQ NUBLT
03890 	ADDD #1
03900 	STD UBLK,X
03910 	LDD #0
03920 	STD UIN,X
03930 	LDD BPSCR+2 2^n
03940 	DECB
03950 	ANDB UBLK+1,X end of screen?
03960 	BNE NUBLT+2
03970 	DOCOL
03980 	FDB QEXEC
03990 	FDB XMACH
04000 NUBLT	PULS Y end interp
04010 	NEXT
04090 *
*/
void NUBLK( void )
{	//natural_t probe = ( &hBPSCR.parameterLink[ 0 ].integer - 1 );
	if ( UP.task->activeDiscBlock.integer != 0 )
	{	UP.task->activeDiscBlock.integer += 1;
		UP.task->bufferInputOffset.integer = 0;
		if ( ( UP.task->activeDiscBlock.integer & ( hBPSCR.parameterLink[ 0 ].integer - 1 ) ) != 0 )
		{	goto NO_EXIT;	/* Actually a valid use of an explicit branch? */
		}
	}
	/* IP = ( * RP++ ).cellp; */
	sysSIG.integer = ICODE_LIST_END;	/* This should stop INTERP, but won't stop a non-icode list definition. */ 
NO_EXIT:
	return;
}


/*
04100 	FCC 'FIND'
04110 	FCB 4
04120 	FCB MFORE
04130 	FDB NUBLK-CFAOFF
04140 	FDB BIF+2
04150 	FDB EXPECT-CFAOFF
04160 	FDB HERE-CFAOFF
*/
static character_t sFIND[] = "\x4" "FIND";
definition_header_s hFIND = 
{	{ (natural_t) sFIND },
	{ 0 },
	{ (natural_t) &hNUBLK },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hEXPECT },
	{ (natural_t) &hHERE },
	{ (natural_t) FIND }
};
/*
04170 FIND	LDD 2,U
04180 	ADDD #1 past ct
04190 	STD 2,U
04200 	LDD ,U
04210 FINDL	LDX 2,U
04220 	PSHU D,X
04230 	DOCOL
04240 	FDB PFIND
04250 	FDB XMACH
04260 	LDD ,U flag
04270 	BNE FINDF
04290 	LDX 4,U vocabulary
04300 	LDD GFAOFF-PFAOFF,X parent
04305 	CMPD 4,U root voc?
04310 	BEQ FINDF
04315 	LEAU 4,U
04320 	STD ,U
04330 	BRA FINDL
04360 FINDF	LDD [2,U]
04365 	LEAU 4,U entry
04370 	STD 2,U
04380 	NEXT
04390 *
*/
void FIND( void )
{	cell_u * subtreePtr = SP[ 0 ].cellp;
	character_t * name = SP[ 1 ].chString + 1;	/* PFIND doesn't seem to need the length. */
	definition_header_s * vocabHeader = (definition_header_s *) ( ( (byte_t *) subtreePtr ) - PFAOFF );
	for ( ;; )
	{	SP[ 1 ].chString = name;
		SP[ 0 ].cellp = subtreePtr;
#if defined DBG_FIND
fprintf( standardError, "calling (PFIND) on %s with %p¥n", name, subtreePtr );
#endif
		PFIND();
		if ( ( SP[ 0 ].integer != 0 ) || ( vocabHeader->vocabLink.definitionp == vocabHeader ) )
		{	break;
		}
		vocabHeader = ( vocabHeader->vocabLink ).definitionp;
		subtreePtr = vocabHeader->parameterLink;
	}
	SP[ 0 ].cellp = subtreePtr;
	SP[ 1 ].definitionp = ( * ( SP[ 1 ].cellp ) ).definitionp;
}


/*
04400 	FCC '-DFIND'
04410 	FCB 6
04420 	FCB MFORE
04430 	FDB FIND-CFAOFF
04440 	FDB BIF+2
04450 	FDB 0
04460 	FDB 0
*/
static character_t sDDFIND[] = "\x6" "-DFIND";
definition_header_s hDDFIND =	
{	{ (natural_t) sDDFIND },
	{ 0 },
	{ (natural_t) &hFIND },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) XCOL } ,
/*
04470 DDFIND	DOCOL
04480 	FDB DROOT defs first
04490 	FDB ROOT context next
04500 DFIND1	FDB BL
04510 	FDB WORD name in buf
04520 	FDB FETCH vocab2
04530 	FDB SWAP
04540 	FDB FETCH vocab1
04550 	FDB OVER
04560 	FDB OVER
04570 	FDB EQ same?
04580 	FDB ZBR
04590 	FDB 6
04600 	FDB DROP
04610 	FDB BRANCH
04620 	FDB DFIND2-*-2
04630 	FDB WORDPD buf
04640 	FDB SWAP
04650 	FDB FIND 1st
04660 	FDB OVER
04670 	FDB ZBR
04680 	FDB 6
04690 	FDB ROT
04700 	FDB DROP
04710 	FDB SEMIS
04720 	FDB DROP
04730 	FDB DROP
04740 DFIND2	FDB WORDPD
04750 	FDB SWAP
04760 	FDB FIND 2nd
04770 	FDB SEMIS
04790 *
*/
	{
		{ (natural_t) &hDROOT	},	/* defs first */
		{ (natural_t) &hROOT	},	/* context next */
/* DFIND1: */
		{ (natural_t) &hBL	},
		{ (natural_t) &hWORD	},	/* name in buf */
		{ (natural_t) &hFETCH	},	/* vocab2 */
		{ (natural_t) &hSWAP	},
		{ (natural_t) &hFETCH	},	/* vocab1 */
		{ (natural_t) &hOVER	},
		{ (natural_t) &hOVER	},
		{ (natural_t) &hEQ	},	/* same? */
		{ (natural_t) &hZBR	},
		{ 3 * sizeof (cell_u)	},	/* 6 */
		{ (natural_t) &hDROP	},
		{ (natural_t) &hBRANCH	},
		{ 11 * sizeof (cell_u)	},	/* &hDFIND2-*-2 */
		{ (natural_t) &hWORDPD	},	/* buf */
		{ (natural_t) &hSWAP	},
		{ (natural_t) &hFIND	},	/* 1st */
		{ (natural_t) &hOVER	},
		{ (natural_t) &hZBR	},
		{ 3 * sizeof (cell_u)	},	/* 6 */
		{ (natural_t) &hROT	},
		{ (natural_t) &hDROP	},
		{ (natural_t) &hSEMIS	},
		{ (natural_t) &hDROP	},
		{ (natural_t) &hDROP	},
/* DFIND2: */
		{ (natural_t) &hWORDPD	},
		{ (natural_t) &hSWAP	},
		{ (natural_t) &hFIND	},	/* 2nd */
		{ (natural_t) &hSEMIS	}
	}
};
/*
04800 	FCC '-IFIND'
04810 	FCB 6
04820 	FCB MFORE
04830 	FDB DDFIND-CFAOFF
04840 	FDB BIF+2
04850 	FDB 0
04860 	FDB 0
*/
static character_t sDIFIND[] = "\x6" "-IFIND";
definition_header_s hDIFIND = 
{	{ (natural_t) sDIFIND },
	{ 0 },
	{ (natural_t) &hDDFIND },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) XCOL },
/*
04870 DIFIND	DOCOL
04880 	FDB ROOT context first
04890 	FDB DROOT defs next
04900 	FDB BRANCH
04910 	FDB DFIND1-*-2
05190 *
*/
	{
		{ (natural_t) &hROOT	},	/* context first */
		{ (natural_t) &hDROOT	},	/* defs next */
		{ (natural_t) &hBRANCH	},
		{ 0	},	/* &hDFIND1-*-2 *** For now, I'm patching it in WARM. */
		{ (natural_t) &hSEMIS	}	/* For safety until this can be looked at properly. */
	}
};
