/*
**  bif5_a.c
**  bif-c
**
**  Created by Joel Rees on 2009/08/16.
**  Copyright 2009 __Reiisi_Kenkyuu__. All rights reserved.
**
** Translated to C from BIF5/A, as mechanically as possible.
*/


#include <string.h>	/* for strlen() in MESSAGE */


#include "bif_m.h"

#include "bifst_a.h"

#include "bif7b_a.h"	/* To link into the BIF vocabulary. */
#include "bif5_a.h"


/*
00010 * Include file for BIF
00020 * BIF Copyright 1989 Joel Matthew Rees (See BIF/ASM)
00030 *
00900 	FCC 'IP,'
00910 	FCB MCOMP.OR.3
00920 	FCB MFORE
00930 	FDB SCODE-CFAOFF
00940 	FDB BIF+2
00950 	FDB 0
00960 	FDB 0
*/
static character_t sIPCOM[] = "\x3" "IP,";
definition_header_s hIPCOM = 
{	{ (natural_t) sIPCOM },
	{ MCOMP },
	{ (natural_t) &hSCODE },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) IPCOM }
};
/*
00970 IPCOM	JMP COMPIP
00980 *
** From COMP() in bif4b_a.c (reversing the steal):
06310 COMPIP	LDD ,Y++ robbed by IP,
06320 	PSHU D
06330 	JMP COMMA
*/
void IPCOM( void )
{	( * --SP ) = ( * IP++ );
	COMMA();
}


/*
01000 	FCC '?STACK'
01010 	FCB 6
01020 	FCB MFORE
01030 	FDB IPCOM-CFAOFF
01040 	FDB BIF+2
01050 	FDB 0
01060 	FDB 0
*/
static character_t sQSTACK[] = "\x6" "?STACK";
definition_header_s hQSTACK = 
{	{ (natural_t) sQSTACK },
	{ 0 },
	{ (natural_t) &hIPCOM },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) QSTACK }
};
/*
01070 QSTACK	LDX <UP
01080 	CMPS UR0,X
01090 	BLS *+6
01100 QSTACU	LDB #$0A
01110 	BRA QSTERR
01115 	LDD [UR0,X] hole
01116 	BNE QSTACU
01120 	CMPS US0,X
01130 	BHI *+6
01140 QSTACO	LDB #$0B
01150 	BRA QSTERR
01155 	LDD [US0,X] hole
01156 	BNE QSTACE
01160 	CMPU US0,X
01170 	BLS *+6
01180 QSTACE	LDB #1
01190 	BRA QSTERR
01240 	CMPU UDP,X
01260 	BLS *+4
01270 	NEXT
01280 	LDB #7
01290 QSTERR	CLRA
01300 	PSHU D
01310 	JMP ERROR
01320 *
*/
/* The stack hole checks and associated messages are heuristic, at best. 
** Of course, the pseudo-random sampling, spot-check nature of using this test is also not ironclad.
*/
#if defined STACK_BUMPER_HOLE && STACK_BUMPER_HOLE == 2
void QSTACK( void )
{	if ( ( UP.task->returnStackBase.cellp )[ 1 ].integer != 0 )
	{	mERROR( ARRAY_REFERENCE_OUT_OF_BOUNDS );	/* Need a message about terminal input buffer bounds for this. */
	}
	if ( ( RP > UP.task->returnStackBase.cellp ) || ( ( UP.task->returnStackBase.cellp )[ 0 ].integer != 0 ) )
	{	mERROR( CONTROL_STACK_UNDERFLOW );
	}
	if ( ( RP <= UP.task->dataStackBase.cellp ) || ( (  UP.task->dataStackBase.cellp )[ 1 ].integer != 0 ) )
	{	mERROR( CONTROL_STACK_OVERFLOW );
	}
	if ( ( SP > UP.task->dataStackBase.cellp ) || ( (  UP.task->dataStackBase.cellp )[ 0 ].integer != 0 ) )
	{	mERROR( DATA_STACK_UNDERFLOW );
	}
	if ( SP <= UP.task->dictionaryAllocationPointer.cellp ) 
	{	mERROR( DATA_STACK_OVERFLOW );
	}
}
#else	/* --> !defined STACK_BUMPER_HOLE || STACK_BUMPER_HOLE != 2 */
#	error "Fix the number of tests in the hole above!"
#endif /* defined STACK_BUMPER_HOLE && STACK_BUMPER_HOLE == 2 */


/*
01400 	FCC 'BUFFER'
01410 	FCB 6
01420 	FCB MFORE
01430 	FDB QSTACK-CFAOFF
01440 	FDB BIF+2
01450 	FDB BLK-CFAOFF
01460 	FDB CCOMMA-CFAOFF
*/
static character_t sBUFFER[] = "\x6" "BUFFER";
definition_header_s hBUFFER = 
{	{ (natural_t) sBUFFER },
	{ 0 },
	{ (natural_t) &hQSTACK },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hBLK },
	{ (natural_t) &hCCOMMA },
	{ (natural_t) BUFFER }
};
/*
01470 BUFFER	PSHS Y
01480 	LDY <UP
01490 	LDD UUSE,Y
01495 	PSHS D save it
01500 	PSHU D
01510 	DOCOL
01520 	FDB ADDBUF
01530 	FDB ZBR prev?
01540 	FDB -6
01550 	FDB XMACH
01560 	PULU D
01570 	STD UUSE,Y new use
01580 	LDX ,S buffer
01590 	LDD ,X block
01600 	BPL BUFNW
01610 	ANDA #$7F mask update
01620 	LEAX 2,X data
01630 	PSHU D,X
01640 	LDD #0 write
01650 	PSHU D
01660 	DOCOL
01670 	FDB RW
01680 	FDB XMACH
01690 BUFNW	PULU D new block
01700 	PULS X
01710 	STD ,X
01720 	STX UPREV,Y
01730 	LEAX 2,X data
01740 	PSHU X
01750 	PULS Y
01760 	NEXT
01790 *
*/
void BUFFER( void )		/* **BUG** I really need to fix this, if I actually plan on using it. */
{	cell_u saveLRU = UP.task->leastRecentBuffer;
	/* BUG: If this is mostRecentBuffer somehow, need to do something else. */
	( * --SP ) = saveLRU;
#if defined MAY_NOT_BE_A_BUG
	if ( saveLRU.cellp == UP.task->mostRecentBuffer.cellp )	/* Maybe this would shim the BUG: */
	{
/* dbg */	fprintf( standardError, "*** Disk buffer collision: FIRST:%p, LIMIT:%p, USE==PREV:%p[sector:%lx]\n", 
/* dbg */			 UP.task->firstByteOfBuffers.bytep, UP.task->limitOfBufferRAM.bytep,
/* dbg */			 saveLRU.bytep, (unsigned long) saveLRU.cellp[ 0 ].integer );
/* shim */	mCALLdef( hADDBUF );
/* shim */	saveLRU = SP[ 1 ];
/* dbg */	fprintf( standardError, "***\tMoving USE to:%p[sector:%lx] (+BUF flag = %lx)\n", 
/* dbg */			 saveLRU.bytep, (unsigned long) saveLRU.cellp[ 0 ].integer, ( * SP++ ).integer );
	}
#endif /* defined MAY_NOT_BE_A_BUG */
	do	/* Find a new buffer to be the new useBuffer. */
	{	ADDBUF();
	} while ( ( * ++SP ).integer == 0L );	/* If it hits PREV, it's supposed to try again. */
	UP.task->leastRecentBuffer = ( * SP++ );	/* Not actually least recent? "useBuffer" would have been better. */
	if ( ( saveLRU.cellp[ 0 ].integer & BUFF_DIRTY_FLAG ) != 0 )
	{	( * --SP ).cellp = saveLRU.cellp + BUFF_CTRL_WID / sizeof (cell_u);
		( * --SP ).integer = saveLRU.cellp[ 0 ].integer & ~BUFF_DIRTY_FLAG;
		( * --SP ).integer = 0L;
		RW();
	}
	UP.task->mostRecentBuffer = saveLRU;
	saveLRU.cellp[ 0 ].integer = SP[ 0 ].integer;	/* Store the block number. */
	SP[ 0 ].cellp = saveLRU.cellp + BUFF_CTRL_WID / sizeof (cell_u);
}


/*
01800 	FCC 'BLOCK'
01810 	FCB 5
01820 	FCB MFORE
01830 	FDB BUFFER-CFAOFF
01840 	FDB BIF+2
01850 	FDB 0
01860 	FDB BS-CFAOFF
*/
static character_t sBLOCK[] = "\x5" "BLOCK";
definition_header_s hBLOCK = 
{	{ (natural_t) sBLOCK },
	{ 0 },
	{ (natural_t) &hBUFFER },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ (natural_t) &hBS },
	{ (natural_t) BLOCK }
};
/*
01870 BLOCK	PSHS Y
01880 	LDY <UP
01890 	LDD UOFFS,Y
01900 	ADDD ,U
01910 	STD ,U
01920 	LDX UPREV,Y
01930 BLOKL	LDD ,X block
01940 	ANDA #$7F mask update
01950 	CMPD ,U this buffer?
01960 	BEQ BLOKFD
01970 	PSHU X
01980 	DOCOL
01990 	FDB ADDBUF
02000 	FDB TBR
02010 	FDB BLOKLE-*-2
02020 	FDB DROP buffer
02030 	FDB DUP block
02040 	FDB BUFFER lru
02050 	FDB OVER
02060 	FDB OVER
02070 	FDB SWAP
02080 	FDB MONE
02090 	FDB RW get block
02100 	FDB SUB2
02110 BLOKLE	FDB XMACH
02120 	PULU X buffer
02130 	BRA BLOKL
02140 BLOKFD	STX UPREV,Y
02150 	LEAX 2,X data
02160 	STX ,U
02165 	PULS Y
02170 	NEXT
02180 *
*/
/*
BLOCK   ( n --- buffer )
        Get BUFFER containing block n, relative to OFFSET.  If block n
        is not in a buffer, bring it in.  Returns buffer address.
*/
void BLOCK( void )
{	natural_t blockNumber = SP[ 0 ].integer + UP.task->activeDriveOffset.integer;
	cell_u * buffer = SP[ 0 ].cellp = UP.task->mostRecentBuffer.cellp;
#if defined DBG_WORD_PARSE
printf( "BLOCK start comparing %lx (%lx) == %lx stack: %p\n", buffer[ 0 ].integer,
	buffer[ 0 ].integer & ~BUFF_DIRTY_FLAG, blockNumber, SP );
#endif
	while ( ( buffer[ 0 ].integer & ~BUFF_DIRTY_FLAG ) != blockNumber )
	{
		ADDBUF();
		if ( ( * SP++ ).integer == 0L )	/* Back to PREVious? (and drop the flag) */
		{	( * --SP ).integer = blockNumber;
			BUFFER();	/* returns buffer (data) address. */
			SP[ 1 ].cellp = SP[ 0 ].cellp - BUFF_CTRL_WID / sizeof (cell_u);
			( * --SP ).integer = blockNumber;
			( * --SP ).integer = -1L;
			RW();
		}
		buffer = SP[ 0 ].cellp;
#if defined DBG_WORD_PARSE
printf( "BLOCK comparing %lx (%lx) == %lx stack: %p\n", buffer[ 0 ].integer,
	buffer[ 0 ].integer & ~BUFF_DIRTY_FLAG, blockNumber, SP );
#endif
	}
	UP.task->mostRecentBuffer.cellp = buffer;
	SP[ 0 ].cellp = buffer + BUFF_CTRL_WID / sizeof (cell_u);	/* This feels really awkward. */
#if defined DBG_WORD_PARSE
printf( "BLOCK returning %lx\n", SP[ 0 ].integer );
#endif
}


/*
02200 	FCC '(LINE)'
02210 	FCB 6
02220 	FCB MFORE
02230 	FDB BLOCK-CFAOFF
02240 	FDB BIF+2
02250 	FDB PINSTA-CFAOFF
02260 	FDB XLOOP-CFAOFF
*/
static character_t sXLINE[] = "\x6" "(LINE)";
definition_header_s hXLINE = 
{	{ (natural_t) sXLINE },
	{0 },
	{ (natural_t) &hBLOCK },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hPINSTA },
	{ (natural_t) &hXLOOP },
	{ (natural_t) XCOL },
/*
02270 XLINE	DOCOL	see fig-FORTH model
02280 	FDB TOR
02290 	FDB CPERL line width
02300 	FDB BPBUF
02310 	FDB SSMOD byte in sector
02320 	FDB RFROM
02330 	FDB BPSCR
02340 	FDB STAR base of screen
02350 	FDB ADD
02360 	FDB BLOCK
02370 	FDB ADD byte of buffer
02380 	FDB CPERL
02390 	FDB SEMIS
02400 *
*/
	{
		{ (natural_t) &hTOR	},
		{ (natural_t) &hCPERL	},	/* line width */
		{ (natural_t) &hBPBUF	},
		{ (natural_t) &hSSMOD	},	/* byte in sector */
		{ (natural_t) &hRFROM	},
		{ (natural_t) &hBPSCR	},
		{ (natural_t) &hSTAR	},	/* base of screen */
		{ (natural_t) &hADD	},
		{ (natural_t) &hBLOCK	},
		{ (natural_t) &hADD	},	/* byte of buffer */
		{ (natural_t) &hCPERL	},
		{ (natural_t) &hSEMIS	}
	}
};


/*
02500 	FCC '.LINE'
02510 	FCB 5
02520 	FCB MFORE
02530 	FDB XLINE-CFAOFF
02540 	FDB BIF+2
02550 	FDB DOTQ-CFAOFF
02560 	FDB DOTR-CFAOFF
*/
static character_t sDOTLIN[] = "\x5" ".LINE";
definition_header_s hDOTLIN = 
{	{ (natural_t) sDOTLIN },
	{ 0 },
	{ (natural_t) &hXLINE },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hDOTQ },
	{ (natural_t) &hDOTR },
	{ (natural_t) XCOL },
/*
02570 DOTLIN	DOCOL	see fig-FORTH model
02580 	FDB XLINE
02590 	FDB DTRAIL
02600 	FDB TYPE
02610 	FDB SEMIS
02690 *
*/
	{
		{ (natural_t) &hXLINE	},
		{ (natural_t) &hDTRAIL	},
		{ (natural_t) &hTYPE	},
		{ (natural_t) &hSEMIS	}
	}
};


/*
02700 	FCC 'SPACES'
02710 	FCB 6
02720 	FCB MFORE
02730 	FDB DOTLIN-CFAOFF
02740 	FDB BIF+2
02750 	FDB 0
02760 	FDB 0
*/
static character_t sSPACES[] = "\x6" "SPACES";
definition_header_s hSPACES = 
{	{ (natural_t) sSPACES },
	{ 0 },
	{ (natural_t) &hDOTLIN },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) SPACES }
};
/*
02770 SPACES	LDD ,U	see fig-FORTH model
02780 	BGT SPACEY
02783 	LEAU 2,U
02785 	NEXT
02790 SPACEY	DOCOL
02800 	FDB ZERO
02810 	FDB XDO
02820 	FDB SPACE
02830 	FDB XLOOP
02840 	FDB -6
02850 	FDB SEMIS
02890 *
*/
void SPACES( void )
{	snatural_t count = ( * SP++ ).sinteger;
	while ( --count >= 0 )	/* Getting tired of slavish conformance, I guess. */
	{	SPACE();
	}
}


/*
02900 	FCC '<#'
02910 	FCB 2
02920 	FCB MFORE
02930 	FDB SPACES-CFAOFF
02940 	FDB BIF+2
02950 	FDB 0
02960 	FDB BUILDS-CFAOFF
*/
static character_t sBEGHSH[] = "\x2" "<#";
definition_header_s hBEGHSH = 
{	{ (natural_t) sBEGHSH },
	{ 0 },
	{ (natural_t) &hSPACES },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ (natural_t) &hBUILDS },
	{ (natural_t) BEGHSH }
};
/*
02970 BEGHSH	LDX <UP
02980 	LDD UPAD,X
02990 	STD UHLD,X
03000 	NEXT
03090 *
*/
void BEGHSH( void )
{	UP.task->padMarker = UP.task->numericConversionScratchPad;
}


/*
03100 	FCC '#>'
03110 	FCB 2
03120 	FCB MFORE
03130 	FDB BEGHSH-CFAOFF
03140 	FDB BIF+2
03150 	FDB STORE-CFAOFF
03160 	FDB TICK-CFAOFF
*/
static character_t sENDHSH[] = "\x2" "#>";
definition_header_s hENDHSH = 
{	{ (natural_t) sENDHSH },
	{ 0 },
	{ (natural_t) &hBEGHSH },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hSTORE },
	{ (natural_t) &hTICK },
	{ (natural_t) ENDHSH }
};
/*
03170 ENDHSH	LDX <UP
03180 	LDD UPAD,X
03190 	SUBD UHLD,X
03200 	STD ,U count
03210 	LDD UHLD,X
03220 	STD 2,U
03230 	NEXT
03290 *
*/
void ENDHSH( void )
{	SP[ 0 ].sinteger = UP.task->numericConversionScratchPad.bytep - UP.task->padMarker.bytep;
	SP[ 1 ] = UP.task->padMarker;
}


/*
03300 	FCC 'SIGN'
03310 	FCB 4
03320 	FCB MFORE
03330 	FDB ENDHSH-CFAOFF
03340 	FDB BIF+2
03350 	FDB SCR-CFAOFF
03360 	FDB 0
*/
static character_t sSIGN[] = "\x4" "SIGN";
definition_header_s hSIGN = 
{	{ (natural_t) sSIGN },
	{ 0 },
	{ (natural_t) &hENDHSH },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hSCR },
	{ (natural_t) &hSIGNOF },
	{ (natural_t) SIGN }
/*
	{ (natural_t) XCOL },
03370 SIGN	DOCOL	see fig-FORTH model
03380 	FDB ROT
03390 	FDB ZLESS
03400 	FDB ZBR
03410 	FDB SIGNP-*-2
03420 	FDB LIT
03430 	FDB $2D
03440 	FDB HOLD
03450 SIGNP	FDB SEMIS
03490 *
	{	// * Implicit dependency on size of dblnatural_t vs. size of natural_t * /
		{ (natural_t) &hROT	},	// * Need a PICK, along with DOUBLE-SIZE and CELL-SIZE . * /
		{ (natural_t) &hZLESS	},	// * (We want a CELLSPERDOUBLE, really.) * /
		{ (natural_t) &hZBR	},	// * (And we need to make the alignment of dblnatural_t explicit.) * /
		{ 3 * sizeof (cell_u)	},	// * &hSIGNP-*-2 * /
		{ (natural_t) &hLIT	},
		{ 0x2D	},	// * This should also be in the USER table. * /
		{ (natural_t) &hHOLD	},
// * SIGNP: * /
		{ (natural_t) &hSEMIS	}
	}
*/
};
void SIGN(void)
{
	snatural_t signFlag = SP[ 2 ].sinteger;
#if !defined MANUFACTURED_DOUBLE
#	if !defined LOW_C_CELL_FIRST	/* FORTH CPU byte order for doubles. */
	dblnatural_t * stack = (dblnatural_t *) ( (char *) SP );
	dblnatural_t temp = * stack++;
	SP = (cell_u *) ( (char *) stack );
	++SP;
	stack = (dblnatural_t *) ( (char *) SP );
	* --stack = temp;
	SP = (cell_u *) ( (char *) stack );
#	else /* defined LOW_C_CELL_FIRST */
	sdblnatural_t temp = ( (sdblnatural_t) SP[ 0 ].sinteger << BITSPERCELL ) | SP[ 1 ].integer;
	++SP;
	SP[ 1 ].integer = (natural_t) temp;
	SP[ 0 ].sinteger = (snatural_t) ( temp >> BITSPERCELL );
#	endif /* !defined LOW_C_CELL_FIRST */
#else /* defined MANUFACTURED_DOUBLE */
	SP[ 2 ] = SP[ 1 ];
	SP[ 1 ] = SP[ 0 ];
	++SP;
#endif /* !defined MANUFACTURED_DOUBLE */
	if ( signFlag < 0 )
	{	( * --SP ).integer = '-';	/* minus sign character */
		HOLD();
	}
}

/*
03500 	FCC '#'
03510 	FCB 1
03520 	FCB MFORE
03530 	FDB SIGN-CFAOFF
03540 	FDB BIF+2
03550 	FDB 0
03560 	FDB 0
*/
static character_t sHASH[] = "\x1" "#";
definition_header_s hHASH = 
{	{ (natural_t) sHASH },
	{ 0 },
	{ (natural_t) &hSIGN },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) HASH },
/*
	{ (natural_t) XCOL },
03570 HASH	DOCOL	see fig-FORTH model
03580 	FDB BASE
03590 	FDB FETCH
03600 	FDB MSMOD
03610 	FDB ROT
03620 	FDB XMACH
03630 	LDB 1,U
03640 	CMPB #9
03650 	BLS HASHX+4
03660 	CMPB #'A-'Z+10
03670 	BLS HASHX+2
03680 HASHX	ADDB #'a-'Z-1
03690 	ADDB #'A-'9-1
03700 	ADDB #'0
03710 	STB 1,U
03720 	DOCOL
03730 	FDB HOLD
03740 	FDB SEMIS
03790 *
	{
		{ (natural_t) &hBASE	},
		{ (natural_t) &hFETCH	},
		{ (natural_t) &hMSMOD	},
		{ (natural_t) &hROT	},
		{ (natural_t) &hXMACH	},	// * Need a word that converts a single digit. * /
		{ (natural_t) &hHOLD	},
		{ (natural_t) &hSEMIS	}
	}
*/
};
void HASH(void)
{	natural_t digit;
	( * --SP ) = UP.task->numericBase;
	mCALLdef( hMSMOD );	/* This might want to be written in C, too. But assembler, of course. */
	digit = SP[ 2 ].integer + '0';	/* Inverting the test order for C. */
	SP[ 2 ] = SP[ 1 ];	/* ROT -- optimize where it makes sense to do so. */
	SP[ 1 ] = SP[ 0 ];
	if ( digit > '9' )
	{	digit += 'A' - '9' - 1;
		if ( digit > 'Z' )	/* Not really optimal, but fairly fast. */
		{	digit += 'a' - 'Z' - 1;	/* half-inspired by base64 et. al. */
		}	/* (62) -> '{', (63) -> '|', (64) -> '}', (65) -> '~', no, not optimal. */
	}	/* A table might be faster? Table of strings? Make the table (pointer) a per-USER variable? */
	SP[ 0 ].integer = digit;
	HOLD();
}


/*
03800 	FCC '#S'
03810 	FCB 2
03820 	FCB MFORE
03830 	FDB HASH-CFAOFF
03840 	FDB BIF+2
03850 	FDB 0
03860 	FDB 0
*/
static character_t sHASHS[] = "\x2" "#S";
definition_header_s hHASHS = 
{	{ (natural_t) sHASHS },
	{ 0 },
	{ (natural_t) &hHASH },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) HASHS },
/*
	{ (natural_t) XCOL },
03870 HASHS	DOCOL
03880 	FDB HASH
03890 	FDB XMACH
03900 	LDD 2,U
03910 	BNE HASHS
03920 	LDD ,U
03930 	BNE HASHS
03940 	NEXT
03950 *
// untested:
	{
		{ (natural_t) &hHASH	},
		{ (natural_t) &hOVER	},
		{ (natural_t) &hOVER	},
		{ (natural_t) &hOR	},
		{ (natural_t) &hZBR	},
		{ -6 * sizeof (cell_u)	},
		{ (natural_t) &hSEMIS	}
	}
*/
};
void HASHS(void)
{	do	/* Want at least one 0 digit if already zero. */
	{	HASH();
	} while ( ( SP[ 0 ].integer != 0 ) || ( SP[ 1 ].integer != 0 ) );	/* Optimize for smaller numbers */
}


/* Since this is for D.R, might as well set the parameter order for it.
** Grab the sdblnatural_t and insert a sign flag under it.
*/
static character_t sSIGNOF[] = "\x7" "SIGN-OF";
definition_header_s hSIGNOF = 
{	{ (natural_t) sSIGNOF },
	{ 0 },
	{ (natural_t) &hHASHS },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) SIGNOF }
};
void SIGNOF(void)
{
#if !defined MANUFACTURED_DOUBLE
#	if !defined LOW_C_CELL_FIRST	/* FORTH CPU byte order for doubles. */
	sdblnatural_t * stack = (sdblnatural_t *) ( (char *) SP );
	sdblnatural_t value = * stack++;
	SP = (cell_u *) ( (char *) stack );
	( * --SP ).sinteger = ( value < 0LL ) ? -1L : 0L;
	stack = (sdblnatural_t *) ( (char *) SP );
	* --stack = value;
	SP = (cell_u *) ( (char *) stack );
#	else /* defined LOW_C_CELL_FIRST */
	sdblnatural_t value = ( (sdblnatural_t) SP[ 0 ].sinteger << BITSPERCELL ) | SP[ 1 ].integer;
	SP[ 1 ].sinteger = ( value < 0LL ) ? -1L : 0L;
	SP[ 0 ].integer = (natural_t) value;
	( * --SP ).sinteger = (snatural_t) ( value >> BITSPERCELL );
#	endif /* !defined LOW_C_CELL_FIRST */
#else /* defined MANUFACTURED_DOUBLE */
	--SP;
	SP[ 0 ] = SP[ 1 ];
	SP[ 1 ] = SP[ 2 ];
	SP[ 2 ].sinteger = ( SP[ 0 ].sinteger < 0 ) ? -1L : 0L;
#endif /* !defined MANUFACTURED_DOUBLE */
}


/*
04000 	FCC 'D.R'
04010 	FCB 3
04020 	FCB MFORE
04030 	FDB HASHS-CFAOFF
04040 	FDB BIF+2
04050 	FDB 0
04060 	FDB 0
*/
static character_t sDDOTR[] = "\x3" "D.R";
definition_header_s hDDOTR = 
{	{ (natural_t) sDDOTR },
	{ 0 },
	{ (natural_t) &hSIGNOF },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ (natural_t) &hDFETCH },
/*	{ (natural_t) DDOTR }, */
	{ (natural_t) XCOL },
/*
04070 DDOTR	DOCOL	see fig-FORTH model
04080 	FDB TOR
04090 	FDB SWAP save sign // Byte order dependency!!!!!!! 
04100 	FDB OVER
04110 	FDB DABS
04120 	FDB BEGHSH
04130 	FDB HASHS
04140 	FDB SIGN
04150 	FDB ENDHSH
04160 	FDB RFROM field width
04170 	FDB OVER
04180 	FDB SUB
04190 	FDB SPACES <0 => no spaces
04200 	FDB TYPE
04210 	FDB SEMIS
04220 *
*/
	{
		{ (natural_t) &hTOR	},	/* field width */
		{ (natural_t) &hSIGNOF	},	/* Get the sign and store it. */
		{ (natural_t) &hDABS	},
		{ (natural_t) &hBEGHSH	},
		{ (natural_t) &hHASHS	},
		{ (natural_t) &hSIGN	},
		{ (natural_t) &hENDHSH	},
		{ (natural_t) &hRFROM	},	/* field width */
		{ (natural_t) &hOVER	},
		{ (natural_t) &hSUB	},
		{ (natural_t) &hSPACES	},	/* <0 => no spaces */
		{ (natural_t) &hTYPE	},
		{ (natural_t) &hSEMIS	}
	}
};


/*
04230 	FCC 'D.'
04240 	FCB 2
04250 	FCB MFORE
04260 	FDB DDOTR-CFAOFF
04270 	FDB BIF+2
04280 	FDB 0
04290 	FDB DDOTR-CFAOFF
*/
static character_t sDDOT[] = "\x2" "D.";
definition_header_s hDDOT = 
{	{ (natural_t) sDDOT },
	{ 0 },
	{ (natural_t) &hDDOTR },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hDTOS },
	{ (natural_t) &hDDOTR },
	{ (natural_t) XCOL },
/*
04300 DDOT	DOCOL	see fig-FORTH model
04310 	FDB ZERO
04320 	FDB DDOTR
04330 	FDB SPACE
04340 	FDB SEMIS
04350 *
*/
	{
		{ (natural_t) &hZERO	},
		{ (natural_t) &hDDOTR	},
		{ (natural_t) &hSPACE	},
		{ (natural_t) &hSEMIS	}
	}
};
/*
04360 	FCC '.R'
04370 	FCB 2
04380 	FCB MFORE
04390 	FDB DDOT-CFAOFF
04400 	FDB BIF+2
04410 	FDB 0
04420 	FDB 0
*/
static character_t sDOTR[] = "\x2" ".R";
definition_header_s hDOTR = 
{	{ (natural_t) sDOTR },
	{ 0 },
	{ (natural_t) &hDDOT },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) XCOL },
/*
04430 DOTR	DOCOL	see fig-FORTH model
04440 	FDB TOR
04450 	FDB STOD
04460 	FDB RFROM
04470 	FDB DDOTR
04480 	FDB SEMIS
04490 *
*/
	{
		{ (natural_t) &hTOR	},
		{ (natural_t) &hSTOD	},
		{ (natural_t) &hRFROM	},
		{ (natural_t) &hDDOTR	},
		{ (natural_t) &hSEMIS	}
	}
};
/*
04500 	FCC '.'
04510 	FCB 1
04520 	FCB MFORE
04530 	FDB DOTR-CFAOFF
04540 	FDB BIF+2
04550 	FDB DDUP-CFAOFF
04560 	FDB DOTLIN-CFAOFF
*/
static character_t sDOT[] = "\x1" ".";
definition_header_s hDOT =	
{	{ (natural_t) sDOT },
	{ 0 },
	{ (natural_t) &hDOTR },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hDDUP },
	{ (natural_t) &hDOTLIN },
#if defined DEBUGGING && DEBUGGING >= 2 && DEBUGGING <= 3
	{ (natural_t) DOT }
#else /* defined DEBUGGING && DEBUGGING >= 2 && DEBUGGING < 0x10 */
	{ (natural_t) XCOL },
/*
04570 DOT	DOCOL	see fig-FORTH model
04580 	FDB STOD
04590 	FDB DDOT
04600 	FDB SEMIS
04610 *
*/
	{	{ (natural_t) &hSTOD	},
		{ (natural_t) &hDDOT	},
		{ (natural_t) &hSEMIS	}
	}
#endif /* defined DEBUGGING && DEBUGGING >= 2 && DEBUGGING < 0x10 */
};
#if defined DEBUGGING && DEBUGGING >= 2 && DEBUGGING < 0x10
void DOT(void)
{	/* kludge it now for debugging because there's a lot of nested reference here. */
	/* By the time we want base conversion, we probably will already have the referenced words ready, */
	/* So we'll hard code it to unsigned hexadecimal. */
	natural_t integer = ( * SP++ ).integer;
	fprintf( standardOutput, "%lx", integer );
}
#endif /* defined DEBUGGING && DEBUGGING >= 2 && DEBUGGING < 0x10 */


/*
04620 	FCC '?'
04630 	FCB 1
04640 	FCB MFORE
04650 	FDB DOT-CFAOFF
04660 	FDB BIF+2
04670 	FDB TOVID-CFAOFF
04680 	FDB TNULL-CFAOFF
*/
static character_t sQDOT[] = "\x1" "?";
definition_header_s hQDOT = 
{	{ (natural_t) sQDOT },
	{ 0 },
	{ (natural_t) &hDOT },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hTOVID },
	{ (natural_t) &hTNULL },
/*	{ (natural_t) QDOT }
*/
	{ (natural_t) XCOL },
	{	{ (natural_t) &hFETCH	},
		{ (natural_t) &hDOT	},
		{ (natural_t) &hSEMIS	}
	}
};
/*
04690 QDOT	LDD [,U++]
04700 	PSHU D
04710 	BRA DOT
04720 *
** Why not
**	ldd [,u]
**	std ,u
** ?
void QDOT( void )
{	SP[ 0 ] = * ( SP[ 0 ].cellp );
	mEXECdef( &hDOT );
}
*/


static character_t sMESS_HEAD[] = "\x6" "MSG # ";
/*
04800 	FCC 'MESSAGE'
04810 	FCB 7
04820 	FCB MFORE
04830 	FDB DOTLIN-CFAOFF
04840 	FDB BIF+2
04850 	FDB MAX-CFAOFF
04860 	FDB 0
*/
static character_t sMESS[] = "\x7" "MESSAGE";
definition_header_s hMESS = 
{	{ (natural_t) sMESS },
	{ 0 },
	{ (natural_t) &hQDOT },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hMAX },
	{ 0 },
	{ (natural_t) MESS }
/*
	{ (natural_t) XCOL },
04870 MESS	DOCOL	see fig-FORTH model
04880 	FDB WARN
04890 	FDB FETCH print text?
04893 	FDB ONE
04896 	FDB AND
04900 	FDB ZBR
04910 	FDB MESSN-*-2
04920 	FDB DDUP not 0?
04930 	FDB ZBR
04940 	FDB MESSX-*-2
04950 	FDB LIT
04960 	FDB 4
04970 	FDB OFFSET
04980 	FDB FETCH
04990 	FDB BPSCR
05000 	FDB SLASH screen offset
05010 	FDB SUB
05020 	FDB DOTLIN
05030 	FDB BRANCH
05040 	FDB MESSX-*-2
05050 MESSN	FDB XDOTQ
05060 	FCB 6
05070 	FCC 'MSG # '
05080 	FDB DOT
05090 MESSX	FDB SEMIS
05190 *
	{	// * Will add code to read strings out of memory to this. * /
		{ (natural_t) &hWARN	},
		{ (natural_t) &hFETCH	},	// * print text? * /
		{ (natural_t) &hLIT	},
		{ MSG_DISK_ON_LINE	},
		{ (natural_t) &hAND	},
		{ (natural_t) &hZBR	},
		{ 13 * sizeof (cell_u)	},	// * &hMESSN-*-2 * /
		{ (natural_t) &hDDUP	},	// * not 0? * /
		{ (natural_t) &hZBR	},
		{ 15 * sizeof (cell_u)	},	// * &hMESSX-*-2 * /
		{ (natural_t) &hLIT	},
		{ ERROR_MESSAGE_SCREEN_OFFSET * sizeof (cell_u)	},	// * was 4, need a constant. USER constant? * /
		{ (natural_t) &hOFFSET	},
		{ (natural_t) &hFETCH	},
		{ (natural_t) &hBPSCR	},
		{ (natural_t) &hSLASH	},	// * screen offset * /
		{ (natural_t) &hSUB	},
		{ (natural_t) &hDOTLIN	},
		{ (natural_t) &hBRANCH	},
		{ 5 * sizeof (cell_u)	},	// * &hMESSX-*-2 * /
// * MESSN: * /
// *		{ (natural_t) &hXDOTQ	},
		{ '\x6MSG'	},
		{ ' # \0'	},
* /
		{ (natural_t) &hLIT	},
		{ (natural_t) sMESS_HEAD	},
		{ (natural_t) &hCOUNT	},
		{ (natural_t) &hTYPE	},
		{ (natural_t) &hDOT	},
// * MESSX: * /
		{ (natural_t) &hSEMIS	}
	}
*/
};
void MESS(void)	/* Re-calculating the branches for edited code is going to be easy to forget. */
{
	if ( ( UP.task->diskOnLine.integer & MSG_DISK_ON_LINE ) != 0 )
	{
		if ( SP[ 0 ].integer != 0 )
		{	( * --SP ).sinteger = ERROR_MESSAGE_SCREEN_OFFSET 
								- ( UP.task->activeDriveOffset.integer / hBPSCR.parameterLink[ 0 ].integer );
			mCALLdef( hDOTLIN );
		}
	}
	else if ( ( UP.task->diskOnLine.integer & MSG_INTERNAL_STRINGS ) != 0 )
	{	
		if ( ( SP[ 0 ].integer != 0 ) && ( SP[ 0 ].integer <= MAX_ERROR_MESSAGE ) )
		{	char * message = errorMessages[ SP[ 0 ].integer ];	/* This should be a BIF linear array. */
			SP[ 0 ].chString = (character_t *) message;
			( * --SP ).integer = strlen( message );	/* I'll eventually put a STRLENGTH word in somewhere. */
			TYPE();
		}
	}
	else
	{
		( * --SP ).chString = sMESS_HEAD;
		COUNT();
		TYPE();
		mCALLdef( hDOT );
	}
}

