
%if 0%{?fedora} > 4 || 0%{?rhel} > 4
#%define _with_gstreamer --with-gstreamer
BuildRequires: libXext-devel libXinerama-devel libXtst-devel
#%define _with_lame --with-lame
#%{?_with_lame:BuildRequires: lame-devel}
%endif

Version: 0.8.3
Release: b1
Name:    kaffeine
License: GPLv2+
Summary: Xine-based media player
Group:   Applications/Multimedia
URL:     http://kaffeine.sourceforge.net/
Source0: http://dl.sourceforge.net/sourceforge/kaffeine/kaffeine-%{version}.tar.bz2
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildArchitectures: i586

BuildRequires: gettext
BuildRequires: kdelibs-devel
#BuildRequires: cdparanoia-devel cdparanoia
BuildRequires: libvorbis-devel
BuildRequires: xine-lib-devel
%if 0%{?fedora} > 7
BuildRequires: libxcb-devel
%endif
# dvb
BuildRequires: glibc-kernheaders
%{?_with_gstreamer:BuildRequires: gstreamer-devel >= 0.10, gstreamer-plugins-base-devel >= 0.10}

# can view dvd's if libdvdcss is available
Requires(hint): libdvdcss

%description
Kaffeine is a xine-based media player for KDE.  It plays back CDs,
and VCDs, and can decode all (local or streamed) multimedia formats
supported by xine-lib.
Additionally, Kaffeine is fully integrated in KDE, it supports drag
and drop and provides an editable playlist, a bookmark system, a
Konqueror plugin, OSD and much more.

%package devel
Summary: Development files for %{name}
Group:   Development/Libraries
Requires: kdelibs-devel
%description devel
%{summary}.


%prep
%setup -q -n kaffeine-%{version}

#%{?nonfree:%patch1 -p1 -b .codecs}

# fix perms on docs
chmod -x AUTHORS ChangeLog INSTALL TODO ||:

# avoid autofoo rerun in 0.8.5
touch -r acinclude.m4 admin/acinclude.m4.in


%build
unset QTDIR || : ; . /etc/profile.d/qt.sh

# easier than patching, and using
#  --with-extra-includes=%{_includedir}/cdda below -- Rex
CPPFLAGS="-I%{_includedir}/cdda"; export CPPFLAGS

%configure \
  --disable-rpath \
  --enable-new-ldflags \
  --disable-debug --disable-warnings \
  --disable-dependency-tracking --disable-final \
  %{?_with_gstreamer} %{!?_with_gstreamer:--without-gstreamer} \
  %{?_with_lame} %{!?_with_lame:--without-lame}

#make %{?_smp_mflags} -C kaffeine/src/input/disc/plugins
make %{?_smp_mflags}

%install
rm -rf $RPM_BUILD_ROOT

#make install DESTDIR=$RPM_BUILD_ROOT -C kaffeine/src/input/disc/plugins/mp3lame
make install DESTDIR=$RPM_BUILD_ROOT

## File lists
# locale's
%find_lang %{name}
# HTML (1.0)
HTML_DIR=$(kde-config --expandvars --install html)
if [ -d $RPM_BUILD_ROOT$HTML_DIR ]; then
for lang_dir in $RPM_BUILD_ROOT$HTML_DIR/* ; do
  if [ -d $lang_dir ]; then
    lang=$(basename $lang_dir)
    echo "%lang($lang) $HTML_DIR/$lang/*" >> %{name}.lang
    # replace absolute symlinks with relative ones
    pushd $lang_dir
      for i in *; do
        [ -d $i -a -L $i/common ] && rm -f $i/common && ln -sf ../common $i/common
      done
    popd
  fi
done
fi

# Unpackaged files
rm -f $RPM_BUILD_ROOT%{_libdir}/lib*.la
rm -f $RPM_BUILD_ROOT%{_datadir}/mimelnk/application/x-mplayer2.desktop

%clean
rm -rf $RPM_BUILD_ROOT

%post
/sbin/ldconfig
touch --no-create %{_datadir}/icons/hicolor ||:
gtk-update-icon-cache -q %{_datadir}/icons/hicolor 2> /dev/null ||:
update-desktop-database >& /dev/null ||:

%postun
/sbin/ldconfig
touch --no-create %{_datadir}/icons/hicolor ||:
gtk-update-icon-cache -q %{_datadir}/icons/hicolor 2> /dev/null ||:
update-desktop-database >& /dev/null ||:


%files -f %{name}.lang
%defattr(-,root,root,-)
#%doc AUTHORS ChangeLog COPYING README TODO
%{_bindir}/kaffeine
%{_libdir}/libkaffeinepart.so
%{_libdir}/kde3/lib*.*
%{_datadir}/appl*/*/*.desktop
%{?_with_gstreamer:%{_datadir}/apps/gstreamerpart/}
%{_datadir}/apps/kaffeine/
%{_datadir}/apps/konqueror/servicemenus/*.desktop
%{_datadir}/apps/profiles/
%{_datadir}/icons/hicolor/*/*/*
%{_datadir}/mimelnk/*/*.desktop
%{_datadir}/service*/*.desktop

%{_libdir}/libkaffeineaudioencoder.so.*
%{_libdir}/libkaffeinedvbplugin.so.*

#%{_libdir}/kde3/libkaffeinemp3lame.*
#%{_datadir}/services/kaffeinemp3lame.desktop

%files devel
%defattr(-,root,root,-)
%{_includedir}/kaffeine/
%{_libdir}/libkaffeineaudioencoder.so
%{_libdir}/libkaffeinedvbplugin.so


%changelog
* Tue Dec 4 2007 Yuichiro Nakada <berry@po.yui.mine.nu>
- Create for Berry Linux
