%{!?kernel: %{expand: %%define kernel %(uname -r)}}

Summary: Utilities for Eagle driven usb modem
Name: eagle-usb
Version: 2.3.2
Release: b1
License: GPL
Group: Networking/Daemons
Source0: %{name}-%{version}.tar.bz2
URL: http://www.eagle-usb.org
Buildroot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
Provides: %{name} = %{version}
Obsoletes: adiusbadsl, eagle
BuildArchitectures: i586

%description
This is an enhanced version of the Linux driver for DSL modems based
on the Analog chipset Eagle 8051. The Sagem F@st 800 modem as well as
USRobotics DSL modems are based on this chipset.

Depending on your setup/isp, you might also need ppp and/or a dhcp client.

You'll find latest revision of this driver and a dedicated french
newsgroup at the following URL:

http://www.eagle-usb.org

%prep

%setup -q

%build
%configure
make %{?_smp_mflags}

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install

%clean
rm -rf $RPM_BUILD_ROOT

%pre

%post
hash -r

%preun
%{_sbindir}/fctStopAdsl -sf
if [ $1 -eq 0 ] ; then
	# disable autostart service
	# - mandrake specific script
	if test -e /etc/init.d/internet ; then \
		/sbin/chkconfig --del internet &>/dev/null ; \
	fi
	# - generic script
	if test -e %{_sysconfdir}/init.d/eagle-usb ; then \
		/sbin/chkconfig --del eagle-usb &>/dev/null ; \
		/sbin/update-rc.d -f eagle-usb remove &>/dev/null ; \
	fi
fi
# return 0
echo -n

%postun
hash -r

%files
%defattr(-,root,root)
#%doc README TODO
#%{_mandir}/man8/eagleconfig.8*
#%{_mandir}/man8/eagleconfig_front.bash.8*
#%{_mandir}/man8/eaglectrl.8*
#%{_mandir}/man8/eaglediag.8*
#%{_mandir}/man8/eaglestat.8*
#%{_mandir}/man8/eagletestconnec.8*
#%{_mandir}/man8/fctStartAdsl.8*
#%{_mandir}/man8/fctStopAdsl.8*
#%{_mandir}/man8/pppoa.8*
#%{_mandir}/man8/startadsl.8*
#%{_mandir}/man8/stopadsl.8*

%{_sbindir}/fctStartAdsl
%{_sbindir}/fctStopAdsl
%{_sbindir}/startadsl
%{_sbindir}/stopadsl
#%{_sbindir}/eagleconnect.tcl
%{_sbindir}/eagleconfig
%{_sbindir}/eagleconfig_front.bash
%{_sbindir}/eaglectrl
%{_sbindir}/eaglediag
%{_sbindir}/eaglestat
%{_sbindir}/eagletestconnec
%{_sbindir}/pppoa

%dir %{_sysconfdir}/%{name}
%{_sysconfdir}/%{name}/CMVei.txt
%{_sysconfdir}/%{name}/CMVep.txt
%{_sysconfdir}/%{name}/CMVepES.txt
%{_sysconfdir}/%{name}/CMVepFR.txt
%{_sysconfdir}/%{name}/CMVepIT.txt
%{_sysconfdir}/%{name}/eagle-usb.conf.template
%{_sysconfdir}/%{name}/ppp_options.template
%{_sysconfdir}/%{name}/setvars
%{_sysconfdir}/%{name}/eagle-usb_must_be_configured

%dir %{_datadir}/%{name}/dsp
%{_datadir}/%{name}/dsp/dsp_code_pots.bin
%{_datadir}/%{name}/dsp/dsp_code_isdn.bin

%dir %{_datadir}/%{name}/lang
#%{_datadir}/%{name}/lang/br
#%{_datadir}/%{name}/lang/cz
#%{_datadir}/%{name}/lang/de
%{_datadir}/%{name}/lang/en
%{_datadir}/%{name}/lang/es
#%{_datadir}/%{name}/lang/fr
#%{_datadir}/%{name}/lang/f2
#%{_datadir}/%{name}/lang/gr
#%{_datadir}/%{name}/lang/it
#%{_datadir}/%{name}/lang/mk
#%{_datadir}/%{name}/lang/pl

#%dir %{_sysconfdir}/%{name}/eagleconnect
#3%{_sysconfdir}/%{name}/eagleconnect/diagnostic.tcl

#%dir %{_sysconfdir}/%{name}/eagleconnect/lang
#%{_sysconfdir}/%{name}/eagleconnect/images/fichierssysteme.ppm
#%{_sysconfdir}/%{name}/eagleconnect/images/fonts.ppm
#%{_sysconfdir}/%{name}/eagleconnect/lang/doc_fr.txt
#%{_sysconfdir}/%{name}/eagleconnect/lang/fr.msg
#%{_sysconfdir}/%{name}/eagleconnect/parameagleconnect.tcl
#%{_sysconfdir}/%{name}/eagleconnect/reseau.tcl

%{_sysconfdir}/sysconfig/network-scripts/net_cnx_*
%{_sysconfdir}/hotplug/usb/eagle-usb
%{_sysconfdir}/init.d/eagle-usb
#%config(noreplace) %{_sysconfdir}/%{name}/eagleconnect.conf
#( % configure )

%changelog
* Sat Aug 27 2005 Yuichiro Nakada <berry@po.yui.mine.nu>
- Update to 2.3.2
* Tue May 10 2005 Yuichiro Nakada <berry@po.yui.mine.nu>
- Update to 2.3.1
* Sun Feb 13 2005 Yuichiro Nakada <berry@po.yui.mine.nu>
- Create for Berry Linux

#=============================== kernel module ===============================
%package module-%{kernel}
Summary: Kernel module for Eagle driven usb modem
Group:System Environment/Kernel

%description module-%{kernel}
Kernel module for Analog chipset Eagle 8051 The Sagem F@st 800/908 modem as well as
USRobotics DSL modems are based on this chipset.

%pre module-%{kernel}

%post module-%{kernel}
depmod -a

%preun module-%{kernel}
if lsmod | grep -q eagle-usb ; then
	rmmod eagle-usb
fi

%postun module-%{kernel}
depmod -a

%files module-%{kernel}
%defattr(-,root,root)
/lib/modules/%{kernel}/misc/eagle-usb.*
