#! /bin/bash
# Program : make_tarbz2.sh
# Author : Benot Audouard aka baud123@tuxfamily.org
# Goal : make a tar.bz2 file for latest eagle-usb developments
# verify all checks previously done by hand at 
# http://dev.eagle-usb.org/wakka.php?wiki=CheckListRelease

### initialization
# I suppose it is launched from eagleusb/distrib/tarbz2/
cd ../../..
VERSION=`cat eagleusb/VERSION`
REP_EAGLE=eagle-usb-${VERSION}
REP_EAGLE_PREV=eagle-usb-${VERSION}_prev

# keep previous version to make doc & html
# latest version is downloaded from CVS
mv eagleusb ${REP_EAGLE_PREV}

# download latest version from CVS asynchronously
export CVSROOT=:ext:baud123@cvs.gna.org:/cvs/eagleusb
export CVS_RSH=ssh
cvs -d baud123@cvs.gna.org:/cvs/eagleusb co eagleusb &

# make documentation while downloading latest version
# in previous directory (up-to-date I hope...)
cd ${REP_EAGLE_PREV}
./autogen.sh
./configure
cd doc
make man && make html
RESULTAT_MAKE=$?
# result will be checked afterwards...
cd ../..

# wait for end of download (if not yet finished...)
echo "wait for end of CVS download"
wait %1
echo "download seems ok : $?"

# rename the directory that has just be downloaded
mv eagleusb ${REP_EAGLE}

cd ${REP_EAGLE}
./autogen.sh # never forget the autogen.sh !!!
cd ..

# copy documentation : it will be newer than files so that a user launching make
# will not have to make documentation again (some requirements avoided...)
if [ ${RESULTAT_MAKE} -eq 0 ] ; then
	cd ${REP_EAGLE_PREV}/doc
	cp -R man html ../../${REP_EAGLE}/doc
	cd ../..
else
	echo "error making documentation, exiting"
	exit
fi


# some cleaning CVS dirs, autom4te.cache temporary dir
# *~ files, eagleconfig.pl (not maintained), *.old and *.bak files
find ${REP_EAGLE} -name CVS -exec /bin/rm -R {} \;
find ${REP_EAGLE} -name "*~" -exec /bin/rm {} \;
find ${REP_EAGLE} -name "*.bak" -exec /bin/rm {} \;
find ${REP_EAGLE} -name "*.log" -exec /bin/rm {} \;
rm -R ${REP_EAGLE}/utils/eagleconfig.pl
rm -R ${REP_EAGLE}/autom4te.cache
tar jcvf ${REP_EAGLE}.tar.bz2 ${REP_EAGLE}

echo "the file ${REP_EAGLE}.tar.bz2 is available"
