/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.ui.fields;

import java.io.File;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;

import benten.ui.fields.messages.TextFieldMessages;

/**
 * フォルダーを選択するためのテキスト・フィールド。
 *
 * <UL>
 * <LI>ファイル・システムのフォルダーを選択するためのフィールド・クラスです。
 * </UL>
 *
 * @author KASHIHARA Shinji
 */
public class FolderTextField extends FileTextField implements IFolderTextField {

	/**
	 * (*)テキストフィールドのためのメッセージ。
	 */
	protected static final TextFieldMessages fMsg = new TextFieldMessages();

	/**
	 * コンストラクター。
	 * @param parent 親コンポジット
	 */
	public FolderTextField(final Composite parent) {
		super(parent, ""); //$NON-NLS-1$
	}

	/**
	 * コンストラクター。
	 * @param parent 親コンポジット
	 * @param labelText ラベル・テキスト
	 */
	public FolderTextField(final Composite parent, final String labelText) {
		super(parent, labelText);
	}

	@Override
	protected void openDialog() {
		final DirectoryDialog dialog = new DirectoryDialog(text.getShell());
		dialog.setMessage(fMsg.getMsg011());
		dialog.setFilterPath(getDefaultPath());
		final String selected = dialog.open();
		if (selected != null) {
			text.setText(selected);
		}
	}

	@Override
	protected String resolvePath(String path) {
		if (path == null) {
			return ""; //$NON-NLS-1$
		}
		final File file = new File(path);
		if (file.isFile()) {
			path = file.getParent();
		}
		return path;
	}
}
