/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Status;

/**
 * UI ステータス。
 *
 * @author KASHIHARA Shinji
 */
public class UiStatus extends Status {

	/** OK ステータス */
	public static final UiStatus OK_STATUS = new UiStatus();

	/** プロジェクト */
	private IProject project;

	/**
	 * コンストラクター。
	 */
	public UiStatus() {
		this(OK, null);
	}

	/**
	 * コンストラクター。
	 * @param severity 重大度
	 * @param message メッセージ
	 */
	public UiStatus(final int severity, final String message) {
		super(severity, UiPlugin.getDefault().getPluginId(), message);
	}

	/**
	 * コンストラクター。
	 * @param severity 重大度
	 * @param message メッセージ
	 * @param exception 例外
	 */
	public UiStatus(final int severity, final String message, final Throwable exception) {
		super(severity, UiPlugin.getDefault().getPluginId(), message, exception);
	}

	/**
	 * コンストラクター。
	 * @param severity 重大度
	 * @param code コード
	 * @param message メッセージ
	 * @param exception 例外
	 */
	public UiStatus(final int severity, final int code, final String message, final Throwable exception) {
		super(severity, UiPlugin.getDefault().getPluginId(), code, message, exception);
	}

	/**
	 * プロジェクトを取得。
	 * @return プロジェクト
	 */
	public IProject getProject() {
		return project;
	}

	/**
	 * プロジェクトを設定。
	 * @param resource プロジェクトまたはプロジェクトに含まれるリソース
	 */
	public void setProject(final IResource resource) {
		if (resource instanceof IProject) {
			this.project = (IProject) resource;
		} else {
			this.project = resource.getProject();
		}
	}
}
