/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.ui.messages;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * Benten UI プラグインの基底クラスのためのメッセージ。
 *
 * リソースバンドル定義: [AbstractBentenUiPluginMessages]。<BR>
 * このクラスはリソースバンドル定義書から自動生成されたリソースバンドルクラスです。<BR>
 * 既知のロケール<BR>
 * <UL>
 * <LI>en
 * <LI>ja
 * </UL>
 */
public class AbstractBentenUiPluginMessages {
    /**
     * リソースバンドルオブジェクト。
     *
     * 内部的に実際に入力を行うリソースバンドルを記憶します。
     */
    private ResourceBundle fResourceBundle;

    /**
     * AbstractBentenUiPluginMessagesクラスのコンストラクタ。
     *
     * 基底名[AbstractBentenUiPluginMessages]、デフォルトのロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     */
    public AbstractBentenUiPluginMessages() {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/ui/messages/AbstractBentenUiPluginMessages");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * AbstractBentenUiPluginMessagesクラスのコンストラクタ。
     *
     * 基底名[AbstractBentenUiPluginMessages]、指定されたロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     */
    public AbstractBentenUiPluginMessages(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/ui/messages/AbstractBentenUiPluginMessages", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * AbstractBentenUiPluginMessagesクラスのコンストラクタ。
     *
     * 基底名[AbstractBentenUiPluginMessages]、指定されたロケール、指定されたクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     * @param loader クラスローダの指定
     */
    public AbstractBentenUiPluginMessages(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/ui/messages/AbstractBentenUiPluginMessages", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * 内部的に保持しているリソースバンドルオブジェクトを取得します。
     *
     * @return 内部的に保持しているリソースバンドルオブジェクト。
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[AbstractBentenUiPluginMessages], key[Msg.001]
     *
     * [Error occurred] (en)<br>
     * [エラーが発生しました] (ja)<br>
     *
     * @return key[Msg.001]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getMsg001() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Error occurred";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Msg.001");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }
}
