/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.filter.dialogs;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

import benten.twa.BentenTwaConstants;
import benten.twa.filter.messages.BentenExportHtmlMessages;
import benten.twa.filter.status.BentenExportHtmlStatus;
import benten.twa.ui.dialogs.AbstractWorkflowDialog;
import benten.ui.UiStatus;
import benten.ui.UiStatusException;
import benten.ui.fields.FolderTextField;
import benten.ui.fields.ResourceFolderTextField;

/**
 * HTML エクスポート・ダイアログです。
 *
 * 翻訳成果のエクスポート
 *
 * <pre>
 * 翻訳成果物をプロジェクトからエクスポートします。
 *   1.  XLIFF とインポートされた翻訳対象物をもちいて、翻訳成果物をエクスポートします。
 * </pre>
 *
 * ★基本設計「翻訳ワークフロー支援機能: 翻訳対象物－翻訳中間形式変換機能: HTMLエクスポート機能」に対応します。
 *
 * @author KASHIHARA Shinji
 */
public class ExportHtmlDialog extends AbstractWorkflowDialog {

	/**
	 * HTMLエクスポート機能のためのメッセージ。
	 */
	protected static final BentenExportHtmlMessages fMsg = new BentenExportHtmlMessages();

	/** コントロール・コンテナー */
	private final ExportHtmlControls controls = new ExportHtmlControls();

	/** コントロール・コンテナー・クラス */
	public static class ExportHtmlControls {

		/** 入力 XLIFF ディレクトリー・テキスト */
		public ResourceFolderTextField fromXliffDirText;

		/** 入力 HTML ディレクトリー・テキスト */
		public ResourceFolderTextField fromHtmlDirText;

		/** 出力ディレクトリー・テキスト */
		public FolderTextField toDirText;
	}

	/**
	 * コンストラクター。
	 * @param parentShell 親シェル
	 * @param selection 選択
	 */
	public ExportHtmlDialog(final Shell parentShell, final IStructuredSelection selection) {
		super(parentShell, selection, fMsg.getWindowTitle());
	}

	@Override
	public void createControls(final Composite composite) {
		composite.setLayout(new GridLayout(3, false));

		controls.fromXliffDirText = new ResourceFolderTextField(composite, fMsg.getDialogCtrlLabelFromXliffDir());
		controls.fromXliffDirText.addModifyListener(this);
		if (getSelectionResource() != null) {
			controls.fromXliffDirText.setText(getSelectionResource().getProject().getName() + "/" //$NON-NLS-1$
					+ BentenTwaConstants.DEFAULT_XLIFF_DIR);
		}

		controls.fromHtmlDirText = new ResourceFolderTextField(composite, fMsg.getDialogCtrlLabelFromHtmlDir());
		controls.fromHtmlDirText.addModifyListener(this);
		if (getSelectionResource() != null) {
			controls.fromHtmlDirText.setText(getSelectionResource().getProject().getName() + "/" //$NON-NLS-1$
					+ BentenTwaConstants.DEFAULT_SOURCE_DIR);
		}
		controls.fromHtmlDirText.setInfoDecoration(fMsg
				.getDialogCtrlLabelFromHtmlDirInfoDescription(BentenTwaConstants.DEFAULT_SOURCE_DIR));

		controls.toDirText = new FolderTextField(composite, fMsg.getDialogCtrlLabelToDir());
		controls.toDirText.addModifyListener(this);
	}

	@Override
	public IStatus getResultStatus() {
		final BentenExportHtmlStatus status = new BentenExportHtmlStatus();
		status.setFromXliffDir(controls.fromXliffDirText.getFile());
		status.setFromHtmlDir(controls.fromHtmlDirText.getFile());
		status.setToDir(controls.toDirText.getFile());
		status.setProject(controls.fromXliffDirText.getResource());
		return status;
	}

	@Override
	public IStatus validate() throws UiStatusException {
		validatePath(controls.fromXliffDirText);
		validatePath(controls.fromHtmlDirText);
		validatePath(controls.toDirText);
		return UiStatus.OK_STATUS;
	}
}
