/*******************************************************************************
 * Copyright (c) 2010  NEC Soft, Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.filter.core;

import java.util.List;

import blanco.xml.bind.BlancoXmlBindingUtil;
import blanco.xml.bind.valueobject.BlancoXmlDocument;
import blanco.xml.bind.valueobject.BlancoXmlElement;
import blanco.xml.bind.valueobject.BlancoXmlNode;

/**
 * ECMA-376 の docx 形式ファイルの中に含まれる document.xml ファイルを翻訳処理するための抽象クラス。
 * 
 * 実際の翻訳処理は、このクラスを継承して実装します。
 * 
 * <UL>
 * <LI>以前は <w:instrText> を処理対象としていたが、これは不都合があるので処理対象外としました。
 * </UL>
 *
 * @author IGA Tosiki
 */
abstract class Ecma376WordXmlParser {
	/**
	 * XML ツリーをパースします。
	 * 
	 * @param document 処理対象となる XML ドキュメント。
	 */
	public void parse(final BlancoXmlDocument document) {
		final List<BlancoXmlNode> top = document.getChildNodes();
		for (BlancoXmlNode nodeRoot : top) {
			if (nodeRoot instanceof BlancoXmlElement) {
				final List<BlancoXmlNode> rootChilds = ((BlancoXmlElement) nodeRoot).getChildNodes();
				for (BlancoXmlNode nodeBody : rootChilds) {
					if (nodeBody instanceof BlancoXmlElement) {
						processChild((BlancoXmlElement) nodeBody);
					}
				}
			}
		}
	}

	/**
	 * XML ツリーの要素をパースします。
	 * 
	 * @param eleChild 処理対象となる XML 要素。
	 */
	void processChild(final BlancoXmlElement eleChild) {
		final String text = BlancoXmlBindingUtil.getTextContent(eleChild);
		if (eleChild.getQName().equals("w:t")) { //$NON-NLS-1$
			// テキスト要素です。これを処理します。
			fireT(eleChild, text);
		} else {
			// 何もしません。
		}

		final List<BlancoXmlNode> childs = eleChild.getChildNodes();
		for (BlancoXmlNode nodeChild : childs) {
			if (nodeChild instanceof BlancoXmlElement) {
				processChild((BlancoXmlElement) nodeChild);
			}
		}
	}

	/**
	 * w:t が発生した場合。
	 * 
	 * @param eleChild 処理対象となる XML 要素。
	 * @param text 発生したテキスト。
	 */
	public abstract void fireT(final BlancoXmlElement eleChild, final String text);
}
