/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.stat.views;

import org.eclipse.swt.SWT;

import benten.cat.stat.model.GlossaryHitRateModel;
import benten.cat.stat.views.messages.GlossaryHitRateViewMessages;
import benten.ui.views.AutoColumnWidthTableViewer;
import benten.ui.views.TableLabelProvider;

/**
 * 用語集ヒット率ビュー。
 * <p>
 * ★基本設計「翻訳ワークフロー支援機能: 翻訳統計取得機能: 用語対訳集ヒット率ビュー」に対応します。
 *
 * @author KASHIHARA Shinji
 */
public class GlossaryHitRateView extends AbstractStatView {

	/**
	 * 用語対訳集ヒット率ビューのためのメッセージ。
	 */
	protected static final GlossaryHitRateViewMessages fMsg = new GlossaryHitRateViewMessages();

	@Override
	protected void createTableViewer(final AutoColumnWidthTableViewer viewer) {
		viewer.addColumn(fMsg.getResource(), 15);
		viewer.addColumn(fMsg.getMoreThan75(), 7, SWT.RIGHT);
		viewer.addColumn(fMsg.getMoreThan50(), 7, SWT.RIGHT);
		viewer.addColumn(fMsg.getMoreThan25(), 7, SWT.RIGHT);
		viewer.addColumn(fMsg.getLessThan25(), 7, SWT.RIGHT);

		viewer.setLabelProvider(new TableLabelProvider() {
			public String getColumnText(final Object obj, final int index) {
				final GlossaryHitRateModel entry = (GlossaryHitRateModel) obj;
				switch (index) {
				case 0:
					return entry.getFile().toString();
				case 1:
					return String.valueOf(entry.getHit75());
				case 2:
					return String.valueOf(entry.getHit50());
				case 3:
					return String.valueOf(entry.getHit25());
				case 4:
					return String.valueOf(entry.getHitUnder25());
				}
				return getText(obj);
			}
		});
	}
}
