/*******************************************************************************
 * Copyright (c) 2007, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
/*******************************************************************************
 * Copyright (c) 2010  NEC Soft, Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.ui.compare;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.editors.text.EditorsUI;

/**
 * コンテンツ・マージ・ビューアー。
 *
 * <UL>
 * <LI>このクラスは {@link org.eclipse.compare.internal.TextEditorPropertyAction} 由来のものです。
 * <LI>パッケージ以外の変更はありません。
 * <LI>比較エディターで使用されます。
 * </UL>
 *
 * @author KASHIHARA Shinji
 */
@SuppressWarnings("restriction")
public class TextEditorPropertyAction extends Action implements IPropertyChangeListener {

	private final MergeSourceViewer[] viewers;
	private final String preferenceKey;
	private final IPreferenceStore store;

	public TextEditorPropertyAction(final String label, final MergeSourceViewer[] viewers, final String preferenceKey) {
		super(label, IAction.AS_CHECK_BOX);
		this.viewers = viewers;
		this.preferenceKey = preferenceKey;
		this.store = EditorsUI.getPreferenceStore();
		if (store != null)
			store.addPropertyChangeListener(this);
		synchronizeWithPreference();
		addActionToViewers();
	}

	private void addActionToViewers() {
		for (int i = 0; i < viewers.length; i++) {
			final MergeSourceViewer viewer = viewers[i];
			viewer.addTextAction(this);
		}
	}

	public MergeSourceViewer[] getViewers() {
		return viewers;
	}

	public void propertyChange(final PropertyChangeEvent event) {
		if (event.getProperty().equals(getPreferenceKey())) {
			synchronizeWithPreference();
		}
	}

	protected void synchronizeWithPreference() {
		boolean checked = false;
		if (store != null) {
			checked = store.getBoolean(getPreferenceKey());
		}
		if (checked != isChecked()) {
			if (toggleState(checked))
				setChecked(checked);
		}
	}

	public String getPreferenceKey() {
		return preferenceKey;
	}

	@Override
	public void run() {
		toggleState(isChecked());
		if (store != null)
			store.setValue(getPreferenceKey(), isChecked());
	}

	public void dispose() {
		if (store != null)
			store.removePropertyChangeListener(this);
	}

	/**
	 * @param checked
	 *            new state
	 * @return <code>true</code> if state has been changed, toggle has been
	 *         successful
	 */
	protected boolean toggleState(final boolean checked) {
		// No-op by default
		return false;
	}

}
