/*******************************************************************************
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.tm.engine.googletranslate;

import benten.cat.tm.core.BentenTmDriver;
import benten.cat.tm.core.BentenTmDriverManager;
import benten.cat.tm.core.BentenTmEngine;

/**
 * このクラスは、Google Translate TM エンジンのドライバー・クラスです。
 * 
 * このクラスを Class.forName() すると、ドライバーが登録されます
 * 
 * @author IGA Tosiki
 * @author YAMAMOTO Koji
 */
public class GoogleTranslateTmDriver implements BentenTmDriver {
	/**
	 * このエンジンのドライバー名。
	 */
	public static final String DRIVER_NAME = "google"; //$NON-NLS-1$

	static {
		// 自分を登録。
		BentenTmDriverManager.registerDriver(new GoogleTranslateTmDriver());
	}

	/**
	 * {@inheritDoc}
	 */
	public String getName() {
		return DRIVER_NAME;
	}

	/**
	 * {@inheritDoc}
	 */
	public BentenTmEngine getEngineInstance() {
		return new GoogleTranslateTmEngine();
	}
}
