#!/usr/bin/perl
#==========================================================================#
#  B.Forum sort.pl Ver.1.01                                              #
#  Hiroaki,Sakuma (sakuma@beetas.org)                                    #
#                                                                          #
# Υץꥱϥץ󥽡Ǥ.                          #
# ̵ǻѤ뤳ȤǤޤ.                                            #
# ʤ, ܺ٤ʻѾ/ǿˤĤƤϲȤ.           #
# http://www.beetas.org/                                                   #
#                                                                          #
# ------------------------------------------------------------------------ #
# Copyright 2002 Hiroaki,Sakuma All Rights Reserved.                       #
# Copyright 2002 BEETAS.org All Rights Reserved.                           #
#                                                                          #
#==========================================================================#
package sort;
$version = '1.01-1';
$revision = '1.01.0001';
$rcfile = '.bforumrc';

unshift (@INC,'.');

use Bforum;

&main;

sub main {

	$start = (times)[0];

	&decode;

	$in{'h'} ||= $in{'help'};
	$in{'v'} ||= $in{'version'};

	$account = 0;

	&Bforum::setting(\%SET,"./$rcfile","$ENV{'HOME'}/$rcfile");
	&Bforum::_path($SET{'USER_DIR'});

	%DSET = %SET;

	if ($in{'v'}) {
		&version;
		exit;
	} elsif ($in{'h'} || !%in) {
		&version;
		&usage;
	}

	&version;
	if ($in{'id'}) {
		if ($in{'r'}) {
			&reflexive("$SET{'USER_DIR'}/$in{'id'}");
		} else {
			&init;
		}
	} else {
		&reflexive("$SET{'USER_DIR'}");
	}
	&finish;

}

sub usage {
	$print = <<"END";
:

åɤν¤ؤޤ
¤ؤեǻꤵ줿̤Ǥ

Ȥ:

ޤbforum.cgiBforum.pmΤǥ쥯ȥذưޤ

\$ ./sort.pl [-ץ] [оݥ]

-r            ƵŪ˥ǥ쥯ȥ򸡺ơоݰʲΥǥ쥯ȥˤ
              ƤΥȤоݤˤޤ
--charset="." åʸɤꤷޤ. ɸeucǤ
              ǤΤ'euc','sjis','jis'Ǥ

 *** оݥȤάƤΥȤоݤˤʤޤ***

:

\$ cd cgi-bin
\$ ./sort.pl -rd Account

\[Win32\]
C:\\web\\cgi-bin\\bforum> sort.pl --charset=sjis -r Account
END
	print code($print);
	exit;
}

sub version {
	printf ("%1s%-74s%1s\n","#",("=" x 74),"#");
	printf code("%1s%-74s%1s\n","#","  B.Forum sort.pl Ver.$version($revision)","#");
	printf code("%1s%-74s%1s\n","#","  Hiroaki,Sakuma (sakuma\@beetas.org)","#");
	printf ("%1s%-74s%1s\n","#"," ","#");
	printf ("%1s%-74s%1s\n","#"," This is free software.","#");
	printf ("%1s%-74s%1s\n","#"," You can use of free.","#");
	printf ("%1s%-74s%1s\n","#"," See the our webpage for more details and news.","#");
	printf ("%1s%-74s%1s\n","#"," http://www.beetas.org/","#");
	printf ("%1s%-74s%1s\n","#"," ","#");
	printf ("%1s %-72s %1s\n","#",("-" x 72),"#");
	printf ("%1s%-74s%1s\n","#"," Copyright 2002 Hiroaki,Sakuma All Rights Reserved.","#");
	printf ("%1s%-74s%1s\n","#"," Copyright 2002 BEETAS.org All Rights Reserved.","#");
	printf ("%1s%-74s%1s\n","#"," ","#");
	printf ("%1s%-74s%1s\n","#",("=" x 74),"#");
	print "\n";
}

sub finish {
	print "\n";
	printf ("%1s%-74s%1s\n","#",("=" x 74),"#");
	printf code("%1s%-20s%30s  %-22s%1s\n","#","  Time",sprintf("%.2f",((times)[0] - $start)),"sec.","#");
	printf code("%1s%-20s%30s  %-22s%1s\n","#","  Account","$account",undef,"#");
	printf ("%1s%-74s%1s\n","#",("=" x 74),"#");
	exit;
}

sub comma {
	my ($tmp1);
	my (@tmp2);
	$tmp1 = $_[0];
	if (!$tmp1) { return "0"; }
	while ($tmp1) {
		unshift (@tmp2,substr($tmp1,-3,3,undef));
	}
	return join(',',@tmp2);
}

sub code {
	undef $tmp2;

	@tmp2 = @_;

	if ($in{'charset'}) {
		if (!$init{'code'}) {
			if ($SET{'NKF'}) {
				eval("use $SET{'NKF'}");
			} elsif ($SET{'JCODE'}) {
				require $SET{'JCODE'} || &error;
			}
			$init{'code'} = 1;
		}

		if ($init{'code'}) {

			$tmp1 = $in{'charset'};

			foreach (@tmp2) {
				if ($_ =~ /\w/) {
					if ($SET{'NKF'}) {
						$$tmp1 = NKF::nkf("--$tmp1",$_);
					} elsif ($SET{'JCODE'}) {
						jcode::convert(\$_,$tmp1,'euc','z');
					}
				}
			}

		}

	}

	return @tmp2;

}

sub reflexive {
	local ($open) = $_[0];

	local (@files,$path);
	opendir (DIR,$open);
	@files = readdir(DIR);
	closedir (DIR);
	foreach $path (@files) {
		if ($path eq '.' || $path eq '..') { next; }
		if ($path eq 'index') {
			$in{'id'} = $open;
			$in{'id'} =~ s/^$SET{'USER_DIR'}\///g;
			&init;
		}
		$path = "$open/$path";
		if (-d $path) { &reflexive($path); }
	}
}

sub init {

	%SET = %DSET;

	&Bforum::setting(\%SET,"$SET{'USER_DIR'}/$in{'id'}/$rcfile");
	&Bforum::_path($SET{'USER_DIR'});

	if (-f "$SET{'USER_DIR'}/$in{'id'}/index") {
		printf ("%-76s","=>$in{'id'}");

		if ($tmp1 = &sort("$SET{'USER_DIR'}/$in{'id'}")) {
			print "Error:$tmp1\n";
		} else {
			print ("\b" x 76);
			printf ("=>$in{'id'}\[Complete\]%-" . (76 -(length($in{'id'})) - 12) . "s\n",undef);
			if ($SET{'COMPRESS_DO'} ne 'N') {
				$compress++;
			}
		}

	}

}

sub sort {

	my ($tmp1,$tmp2);
	my (@ltmp1,@ltmp2,@ltmp3);
	my (%htmp1,%htmp2);

	if (-f "$_[0]/index") {

		$account++;

		$tmp1 = @ltmp1 = &Bforum::_open('file',"$_[0]/index");

		undef $tmp2;
		foreach $tmp3 (@ltmp1) {
			chomp $tmp3;

			if(-d "$_[0]/$tmp3" || "$_[0]/$tmp3.0.bfa") {

				undef %htmp1;

				if ($SET{'INDEX_SORT_DO'} ne 'N') {
					## ǽ˥

					&Bforum::_analysis(\%htmp1,&Bforum::_open(undef,"$_[0]/$tmp3/" . (&Bforum::_open('line',"$_[0]/$tmp3/list") + 1)));

				} else {
					## ˥

					&Bforum::_analysis(\%htmp1,&Bforum::_open(undef,"$_[0]/$tmp3/1"));

				}
				$htmp2{"$htmp1{'date'}"} = $tmp3;

			}

			$tmp2++;
			print ("\b" x 76);
			printf ("=>$in{'id'}\[%s\]#%-" . (76 -(length("$in{'id'}$tmp3")) - 10) . "s#%3d\%", "$tmp3",('=' x (int($tmp2 * (76 - (length("$in{'id'}$tmp3")) - 10) / $tmp1))),(int(100 * $tmp2 / $tmp1)));
		}

		foreach (sort { $b <=> $a } keys %htmp2) {

			push (@ltmp3,"$htmp2{$_}\n");

		}


		&Bforum::_write("$_[0]/index",@ltmp3);
		unlink("$_[0]/status");

	}


	return;
}


sub decode {
	my ($buffer);
	if ($ENV{'REQUEST_METHOD'} eq "POST") {
		read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
	} else { $buffer = $ENV{'QUERY_STRING'}; }
	if (!$buffer) { $buffer = $ARGV[0]; }
	foreach (@ARGV) {
		if ($_ =~ /^--(\S*)=(\S*)$/) {
			$in{$1} = $2;
		} elsif ($_ =~ /^--(.*)$/) {
			$in{$1} = 1;
		} elsif ($_ =~ /^-(.*)$/) {
			foreach (split(//,$1)) {
				$in{$_} = 1;
			}
		} else {
			$in{'id'} = $_;
		}
	}

	undef @_;
}

sub error {
	print "\nError:" . (caller)[2] . '@' . (caller)[1];
	undef @_;
	exit;
}

