#!/usr/bin/perl
#==========================================================================#
#  B.Forum b2n.pl Ver.1.01                                               #
#  2002/6/26                                                             #
#  Hiroaki,Sakuma (sakuma@beetas.org)                                    #
#                                                                          #
# Υץꥱϥץ󥽡Ǥ.                          #
# ̵ǻѤ뤳ȤǤޤ.                                            #
# ʤ, ܺ٤ʻѾ/ǿˤĤƤϲȤ.           #
# http://www.beetas.org/                                                   #
#                                                                          #
# ------------------------------------------------------------------------ #
# Copyright 2002 Hiroaki,Sakuma All Rights Reserved.                       #
# Copyright 2002 BEETAS.org All Rights Reserved.                           #
#                                                                          #
#==========================================================================#
package b2n;

## Ķ˹碌ѹƤ.
$cgi = '/cgi-bin/bforum.cgi';

## ꤳޤ

$version = '1.01-1';
$revision = '1.00.0012';
$rcfile = '.bforumrc';

unshift (@INC,'.');

require './Bforum.pm';

&main;

sub main {

	$start = (times)[0];

	&decode;

	&Bforum::setting(\%SET,"./$rcfile","$ENV{'HOME'}/$rcfile");
	&Bforum::_path($SET{'USER_DIR'});

	$in{'h'} ||= $in{'help'};
	$in{'d'} ||= $in{'delete'};
	$in{'v'} ||= $in{'version'};

	if ($in{'v'}) {
		&version;
		exit;
	} elsif ($in{'h'} || !%in || !$in{'id'}) {
		&version;
		&usage;
		exit;
	}

	if ($in{'mknmz'}) { $SET{'MKNMZ'} = $in{'mknmz'}; }
	$SET{'MKNMZ'} =~ s/\\/\\\\/g;

	&version;
	if ($in{'r'}) {
		&reflexive("$SET{'USER_DIR'}/$in{'id'}");
	} else {
		&init("$SET{'USER_DIR'}/$in{'id'}");
	}
	&finish;

}

sub usage {
	$print = <<"END";
Ȥ:

ޤ, bforum.cgiBForum.pmΤǥ쥯ȥذưޤ.

\$ ./b2n.pl [-ץ] оݥ

-r            ƵŪ˥ǥ쥯ȥ򸡺, оݰʲΥǥ쥯ȥˤ
              ƤΥȤоݤˤޤ.
-p            ¹ԤƤmknmzޥɤϤޤ.
-n            NamazuΥǥåɲä, Ǿ񤭤ޤ.
--mknmz="..." MKNMZܤưޤ. оݤΥȤ$rcfile
              MKNMZܤ̵뤵ޤ.
--charset="." åʸɤꤷޤ. ɸeucǤ.
              ǤΤ'euc','sjis','jis'Ǥ.

:

\$ cd cgi-bin
\$ ./b2n.pl -r Account

\[Win32\]
C:\\web\\cgi-bin\\bforum> b2n.pl --charset=sjis -r Account
END
	print code($print);
}

sub version {
	printf ("%1s%-74s%1s\n","#",("=" x 74),"#");
	printf code("%1s%-74s%1s\n","#","  B.Forum b2n.pl Ver.$version($revision)","#");
	printf code("%1s%-74s%1s\n","#","  Hiroaki,Sakuma (sakuma\@beetas.org)","#");
	printf ("%1s%-74s%1s\n","#"," ","#");
	printf ("%1s%-74s%1s\n","#"," This is free software.","#");
	printf ("%1s%-74s%1s\n","#"," You can use of free.","#");
	printf ("%1s%-74s%1s\n","#"," See the our webpage for more details and news.","#");
	printf ("%1s%-74s%1s\n","#"," http://www.beetas.org/","#");
	printf ("%1s%-74s%1s\n","#"," ","#");
	printf ("%1s %-72s %1s\n","#",("-" x 72),"#");
	printf ("%1s%-74s%1s\n","#"," Copyright 2002 Hiroaki,Sakuma All Rights Reserved.","#");
	printf ("%1s%-74s%1s\n","#"," Copyright 2002 BEETAS.org All Rights Reserved.","#");
	printf ("%1s%-74s%1s\n","#"," ","#");
	printf ("%1s%-74s%1s\n","#",("=" x 74),"#");
	print "\n";
}

sub finish {
	print "\n";
	printf ("%1s%-74s%1s\n","#",("=" x 74),"#");
	printf code("%1s%-20s%30s  %-22s%1s\n","#","  Time",sprintf("%.2f",((times)[0] - $start)),"sec.","#");
	printf code("%1s%-20s%30s  %-22s%1s\n","#","  Account","$account",undef,"#");
	printf code("%1s%-20s%30s  %-22s%1s\n","#","  Directory","$dir",undef,"#");
	printf code("%1s%-20s%30s  %-22s%1s\n","#","  Files","$files",undef,"#");
	printf ("%1s%-74s%1s\n","#",("=" x 74),"#");
	exit;
}

sub comma {
	my ($tmp1);
	my (@tmp2);
	$tmp1 = $_[0];
	if (!$tmp1) { return "0"; }
	while ($tmp1) {
		unshift (@tmp2,substr($tmp1,-3,3,undef));
	}
	return join(',',@tmp2);
}

sub code {
	undef $tmp2;

	@tmp2 = @_;

	if ($in{'charset'}) {
		if (!$init{'code'}) {
			if ($SET{'NKF'}) {
				eval("use $SET{'NKF'}");
			} elsif ($SET{'JCODE'}) {
				require $SET{'JCODE'} || &error(__LINE__ . '@' . __FILE__);
			}
			$init{'code'} = 1;
		}

		if ($init{'code'}) {

			$tmp1 = $in{'charset'};

			foreach (@tmp2) {
				if ($_ =~ /\w/) {
					if ($SET{'NKF'}) {
						$$tmp1 = NKF::nkf("--$tmp1",$_);
					} elsif ($SET{'JCODE'}) {
						jcode::convert(\$_,$tmp1,undef,'z');
					}
				}
			}

		}

	}

	return @tmp2;

}

sub reflexive {
	local ($open) = $_[0];

	local (@files,$path);
	opendir (DIR,$open);
	@files = readdir(DIR);
	closedir (DIR);
	foreach $path (@files) {
		if ($path eq '.' || $path eq '..') { next; }
		if ($path eq 'index') {
			$in{'id'} = $open;
			$in{'id'} =~ s/^$SET{'USER_DIR'}\///g;
			&init("$SET{'USER_DIR'}/$in{'id'}");
		}
		$path = "$open/$path";
		if (-d $path) { &reflexive($path); }
	}
}

sub init {
	&Bforum::setting(\%SET,"$_[0]/$rcfile");
	&Bforum::_path($SET{'USER_DIR'});
	printf ("%-76s","=>$in{'id'}");

	if ($tmp1 = &mknmz($_[0])) {
		print "Error:$tmp1\n";
	}
	print ("\b" x 76);
	printf ("=>$in{'id'}\[Complete\]%-" . (76 -(length($in{'id'})) - 12) . "s\n",undef);

}

sub mknmz {
	&search(@_);
	&_mknmz;
	&rmdir("$_[0]/b2n.tmp");
	return;
}

sub rmdir {
	my (@tmp);
	if (-d $_[0]) {
		opendir(DIR,$_[0]);
		@tmp = readdir(DIR);
		closedir (DIR);
		foreach (@tmp) {
			if ($_ =~ /\.\.?/) { next; }
			if (-d "$_[0]/$_") {
				&rmdir("$_[0]/$_");
			} else {
				unlink("$_[0]/$_");
			}
		}
		rmdir($_[0]);
	}
}


sub search {

	if (-f "$_[0]/index") {
		$account++;
		$tmp1 = @tmp = &Bforum::_open('file',"$_[0]/index");
		undef $tmp2;
		foreach (@tmp) {
			$in{'t'} = $_;
			chomp $in{'t'};

			if (-d "$_[0]/$in{'t'}" || -f "$_[0]/$in{'t'}.0.bfa") {
				undef $tmp3;
				while (1) {

					$tmp3 ++;

					undef %search;
					&Bforum::_analysis(\%search,&Bforum::_open(undef,"$_[0]/$in{'t'}/$tmp3"));

					if (!$search{'message'}) { last; }
					if ($search{'delete'}) { next; }

					$files++;
					if (!-f "$_[0]/$in{'t'}/$tmp3") {
						if (!-d "$_[0]/b2n.tmp") {
							umask (000);
							mkdir ("$_[0]/b2n.tmp",0777) || &error(__LINE__ . '@' . __FILE__);
						}
						if (!-d "$_[0]/b2n.tmp/$in{'t'}") {
							umask (000);
							mkdir ("$_[0]/b2n.tmp/$in{'t'}",0777) || &error(__LINE__ . '@' . __FILE__);
						}
						open (TMP,">$_[0]/b2n.tmp/$in{'t'}/$tmp3");
						binmode (TMP);
						print TMP &Bforum::_open(undef,"$_[0]/$in{'t'}/$tmp3");
						close (TMP);
						utime ($search{'date'},$search{'date'},"$_[0]/b2n.tmp/$in{'t'}/$tmp3");
						unshift (@mknmz,"$_[0]/b2n.tmp/$in{'t'}/$tmp3");
					} else {
						utime ($search{'date'},$search{'date'},"$_[0]/$in{'t'}/$tmp3");
						unshift (@mknmz,"$_[0]/$in{'t'}/$tmp3");
					}
				}
			}

			$tmp2++;
			print ("\b" x 76);
			printf ("=>$in{'id'}\[%s\]#%-" . (76 -(length("$in{'id'}$in{'t'}")) - 10) . "s#%3d\%", "$in{'t'}",('=' x (int($tmp2 * (76 - (length("$in{'id'}$in{'t'}")) - 10) / $tmp1))),(int(100 * $tmp2 / $tmp1)));
		}
		$dir += $tmp2;
	}

}

sub _mknmz {
	if ($SET{'MKNMZ'} && @mknmz) {
		my ($tmp1,$tmp2,$tmp3,$tmp4);
		my (@tmp5);

		open (LIST,">./BF.mknmz.list.tmp");
		binmode (LIST);
		print LIST join("\n",@mknmz);
		close (LIST);

		if ($^O eq "MSWin32" || $^O eq "os2") {
			$tmp1 = "$cgi?id=$in{'id'}&t=\$1&v=";
		} else {
			$tmp1 = "$cgi?id=$in{'id'}&t=\\\$1&v=";
		}
		$tmp1 =~ s/\//\\\//g;
		$tmp1 =~ s/\&/\\&/g;
		if (!$in{'n'}) {
			$tmp2 = "--no-delete";
		}
		@tmp5 = ($SET{'MKNMZ'},"--no-encode-uri",$tmp2,"--media-type=text/bforum","--replace=\"s/.*\\/(.*?)\\//$tmp1/\"","--target-list=./BF.mknmz.list.tmp");

		print ("\b" x 76);
		printf ("=>$in{'id'}\[mknmz\]#%-" . (76 - (length($in{'id'})) - 15) . "s#  0\%",undef);
		open (MKNMZ,"@tmp5 |");
		if ($in{'p'}) {
			print ("\b" x 76);
			print "=>$in{'id'}\[mknmz\]" . join(' ',@tmp5) . "\n";
			while (<MKNMZ>) { print; }
		} else {
			$tmp3 = @mknmz;
			$tmp4 = -2;
			while (<MKNMZ>) {
				$tmp4++;
				if ($tmp4 > 0 && $tmp4 <= $tmp3) {
					print ("\b" x 76);
					printf ("=>$in{'id'}\[mknmz\]#%-" . (76 - (length($in{'id'})) - 15) . "s#%3d\%", ('=' x (int($tmp4 * (76 - (length($in{'id'})) - 15) / $tmp3))),(int(100 * $tmp4 / $tmp3)));
				}
			}
		}
		undef @mknmz;
		close (MKNMZ);

		unlink ("./BF.mknmz.list.tmp");

		return;
#		return system(@tmp5);
	}
}

sub decode {
	my ($buffer);
	if ($ENV{'REQUEST_METHOD'} eq "POST") {
		read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
	} else { $buffer = $ENV{'QUERY_STRING'}; }
	if (!$buffer) { $buffer = $ARGV[0]; }
	foreach (@ARGV) {
		if ($_ =~ /--(.*)=(.*)/) {
			$in{$1} = $2;
		} elsif ($_ =~ /--(.*)/) {
			$in{$1} = 1;
		} elsif ($_ =~ /-(.*)/) {
			foreach (split(//,$1)) {
				$in{$_} = 1;
			}
		} else {
			$in{'id'} = $_;
		}
	}

	undef @_;
}


sub error {
	print "\nError:" . $_[0];
	undef @_;
	exit;
}

