/*!
  \file
  \brief SDL ̏NX

  \author Satofumi KAMIMURA

  $Id$
*/

#include "SdlInit.h"
#include "LogManager.h"
#ifdef MSC
#include "SDL_win.h"
#else
#include <SDL.h>
#endif
#include <stdlib.h>
#include <string>

using namespace beego;


/*!
  \brief SdlInit ̓NX
*/
struct SdlInit::pImpl {
  static bool initialized;
};

bool SdlInit::pImpl::initialized = false;


SdlInit::SdlInit(void) : pimpl(new pImpl) {

  // !!! 肪悤ł΁Adouble lock ɂ

  if (pimpl->initialized == false) {
    if (SDL_Init(0) < 0) {
      // OL^
      LogManager* log = LogManager::getObject();
      std::string message = "SDL_Init(): " + std::string(SDL_GetError());
      log->write(LogManager::Error, message.c_str());
      throw;
    }
    atexit(SDL_Quit);
    pimpl->initialized = true;
  }
}


SdlInit::~SdlInit(void) {
}
