#ifndef LOCK_GUARD_H
#define LOCK_GUARD_H

/*!
  \file
  \brief SDL_mutex ̃bNK[hNX

  \author Satofumi KAMIMURA

  $Id$

  \todo SDL_LockMutex(), SDL_UnlockMutex() bv邾̊֐񋟂ׂ
*/

#ifdef MSC
#include "SDL_win.h"
#else
#include <SDL.h>
#endif
#include <memory>


namespace beego {
  /*!
    \brief SDL_mutex ̃bNK[hNX
  */
  class LockGuard {
    LockGuard(void);
    LockGuard(const LockGuard& rhs);
    LockGuard& operator = (const LockGuard& rhs);

    struct pImpl;
    const std::auto_ptr<pImpl> pimpl;

  public:
    explicit LockGuard(SDL_mutex* mutex);
    ~LockGuard(void);
  };

  extern void LockMutex(SDL_mutex* mutex);
  extern void UnlockMutex(SDL_mutex* mutex);
};

#endif /* !LOCK_GUARD_H */
