/*!
  \file
  \brief SDL_mutex ̃bNK[hNX

  \author Satofumi KAMIMURA

  $Id$
*/

#include "LockGuard.h"

using namespace beego;


/*!
  \brief LockGuard ̓NX
*/
struct LockGuard::pImpl {
  SDL_mutex* using_mutex;

  pImpl(SDL_mutex* mutex) : using_mutex(mutex) {
  }
};


LockGuard::LockGuard(SDL_mutex* mutex) : pimpl(new pImpl(mutex)) {
  SDL_LockMutex(pimpl->using_mutex);
  //fprintf(stderr, "lock: %p\n", pimpl->using_mutex);
}


LockGuard::~LockGuard(void) {
  //fprintf(stderr, "unlock: %p\n", pimpl->using_mutex);
  SDL_UnlockMutex(pimpl->using_mutex);
}


void beego::LockMutex(SDL_mutex* mutex) {
  SDL_LockMutex(mutex);
  //fprintf(stderr, "lock: %p\n", mutex);
}


void beego::UnlockMutex(SDL_mutex* mutex) {
  //fprintf(stderr, "unlock: %p\n", mutex);
  SDL_UnlockMutex(mutex);
}
