/*!
  \example
  \brief Iȃf[^擾Tv

  \author Satofumi KAMIMURA

  $Id$

  usage:
  ./(this program) --urg_port=(COM Port)
*/

#include "UrgCtrl.h"
#include "Delay.h"
#include <SDL.h>

using namespace beego;


int main(int argc, char *argv[]) {

  UrgCtrl urg;
  if (! urg.connect(argc, argv)) {
    printf("UrgCtrl::connect: %s\n", urg.what());
    exit(1);
  }

  // ManualCapture ƁAf[^擾ԕA擾x̂ɒ
  enum { ScanTimes = 5 };
  size_t data_max = urg.getMaxDataLength();
  long* data = new long[data_max];
  for (int i = 0; i < ScanTimes; ++i) {
    int n = urg.capture(data, data_max);
    size_t timestamp = urg.getRawTimestamp();
    printf("n = %d, %d\n", n, timestamp);
    if (n <= 0) {
      break;
    }
    delay(1000);
  }
  delete [] data;

  return 0;
}
