/*!
  \example
  \brief ڑfoCX̒TeXg

  \author Satofumi KAMIMURA

  $Id$
*/

#include "UrgCtrl.h"
#include "ConnectionDeviceSearch.h"
#include "UrgIdHandler.h"
#include <SDL.h>

using namespace beego;


int main(int argc, char *argv[]) {

  // ConnectionDeviceSearch NX錾AڑfoCX̌o^
  ConnectionDeviceSearch device_search;
  device_search.add("/dev/ttyACM2");
  device_search.add("/dev/ttyACM0");
  device_search.add("/dev/ttyACM1");

  // VA ID w肵āAfoCXTs
  // TɃ}b`ڑfoCX́AT₩͍폜邽߁A
  // TfoCXd邱Ƃ͂Ȃ
  UrgIdHandler urg_handler;
  const char* search_id = "H0614967";
  std::string device;
  if (! device_search.search(device, &urg_handler, search_id)) {
    // foCXȂꍇ
    printf("unknown %s device\n", search_id);
    exit(1);
  }
  // foCXꍇ
  printf("found %s device: %s\n", search_id, device.c_str());

  // ڑƃo[W̕\
  UrgCtrl urg;
  if (! urg.connect(device.c_str())) {
    printf("UrgCtrl::connect: %s\n", urg.what());
    exit(1);
  }
  std::vector<std::string> lines;
  if (! urg.getVersionInfo(lines)) {
    printf("UrgCtrl::getVersionInfo: %s\n", urg.what());
    exit(1);
  }

  printf("\n");
  for (std::vector<std::string>::iterator it = lines.begin();
       it != lines.end(); ++it) {
    printf("%s\n", it->c_str());
  }

  return 0;
}
