/*!
  \example
  \brief P̃XL

  \author Satofumi KAMIMURA

  $Id$
*/

#include "UrgCtrl.h"
#include "GetTicks.h"
#include <SDL.h>

using namespace beego;


int main(int argc, char *argv[]) {

  const char*const device = "/dev/usb/ttyUSB0";
  //const char*const device = "/dev/ttyACM0";
  //const char*const device = "COM4";
  const long baudrate = 115200;

  size_t first_ticks = GetTicks();
  UrgCtrl urg;
  if (! urg.connect(device, baudrate)) {
    printf("UrgCtrl::connect: %s\n", urg.what());
    exit(1);
  }

  size_t data_max = urg.getMaxDataLength();
  printf("data_max = %d\n", urg.getMaxDataLength());
  long* data = new long[data_max];

  // ManualCapture  G R}hp邽߁Aŏ̂P̓_~[ǂݏoKv
  urg.capture(data, data_max);

  // f[^\
  int n = urg.capture(data, data_max);
  printf("n = %d\n", n);
  if (n < 0) {
    printf("%s\n", urg.what());
  }
  for (int i = 0; i < n; ++i) {
    printf("%ld,", data[i]);
  }
  printf("\n");
  delete [] data;

  urg.disconnect();
  size_t last_ticks = GetTicks();
  printf("spent: %d\n", last_ticks - first_ticks);

  return 0;
}
