/*!
  \file
  \brief MS/MD R}h̕f[^擾vO

  \author Satofumi KAMIMURA

  $Id$
*/

#include "UrgCtrl.h"
#include <SDL.h>

using namespace beego;


int main(int argc, char *argv[]) {

  if (argc < 3) {
    printf("usage:\n\t%s <first> <last>\n", argv[0]);
    exit(1);
  }

  UrgCtrl urg;
  if (! urg.connect(argc, argv)) {
    printf("UrgCtrl::connect: %s\n", urg.what());
    exit(1);
  }
  urg.setHandstand(true);

  // 擾͈͂̓
  int first_step = atoi(argv[1]);
  int last_step = atoi(argv[2]);

  // f[^̎擾
  enum { TryTimes = 20 };
  int data_max = urg.getMaxDataLength();
  long* data = new long[data_max];

  urg.setCaptureRange(first_step, last_step);
  for (int i = 0; i < TryTimes; ++i) {
    int n = urg.capture(data, data_max);
    if (n >= last_step) {
      //for (int j = 0; j < n; ++j) {
      for (int j = first_step; j <= last_step; ++j) {
	printf("%d, %ld\n", j, data[j]);
      }
    }
    printf("\n");
  }
  return 0;
}
