/*!
  \file
  \brief VAڑ (Windows)

  \author Satofumi KAMIMURA
  \author Tomoaki YOSHIDA

  $Id$

  \todo update() ܂̌؂
*/

#include "SerialCtrl.h"
#include "RingBuffer.h"
#include <errno.h>
#include <windows.h>


/*!
  \brief SerialCtrl ̓NX
*/
struct SerialCtrl::pImpl {
  std::string error_message;
  RingBuffer<char> ring_buffer;
  HANDLE hComm;

  pImpl(void) : error_message("Not connected."), hComm(INVALID_HANDLE_VALUE) {
  }

  ~pImpl(void) {
    disconnect();
  }

  void disconnect(void) {
    if (hComm != INVALID_HANDLE_VALUE) {
      CloseHandle(hComm);
      hComm = INVALID_HANDLE_VALUE;
    }
  }

  bool changeBaudrate(long baudrate) {

    DCB dcb;
    GetCommState(hComm, &dcb);
    dcb.BaudRate = baudrate;
    dcb.ByteSize = 8;
    dcb.Parity = NOPARITY;
    dcb.fParity = FALSE;
    dcb.StopBits = ONESTOPBIT;
    SetCommState(hComm, &dcb);

    return true;
  }

  void update(int timeout, int size = 0) {
#if 0
    enum { BufferSize = 1024 };
    int require_size = (size == 0) ? BufferSize : size;

    // f[^KvȂĂȂ΁A^CAEgݒs
    DWORD dwErrors;
    COMSTAT ComStat;
    ComStat.cbInQue = 0;
    ClearCommError(hComm, &dwErrors, &ComStat);
    printf("cbInQue: %d\n", (int)ComStat.cbInQue);
    if ((size == 0) || (static_cast<int>(ComStat.cbInQue) <= size)) {
      // ^CAEgݒ
      COMMTIMEOUTS pcto;
      GetCommTimeouts(hComm, &pcto);
      pcto.ReadIntervalTimeout = 1;
      pcto.ReadTotalTimeoutConstant = timeout;
      pcto.ReadTotalTimeoutMultiplier = 1;
      SetCommTimeouts(hComm, &pcto);
    }
    char data[BufferSize];
    int read_n = (require_size > BufferSize) ? BufferSize : require_size;
    DWORD n;
    // !!! timeout < 0 ̐ݒ̂ƂɎM҂ɏI悤ȂA
    // !!! Ȃ炩̑ΏKv
    // !!! ۗ
    ReadFile(hComm, data, read_n, &n, NULL);
    ring_buffer.put(data, n);

#else
    enum { BufferSize = 4096 };
    int require_size = (size > 0) ? size : BufferSize;
    int filled = 0;
    int pre_filled = 0;

    // !!! ݂́A^CAEgݒ肳ĂƁAf[^ĂĂ҂
    // !!! ComStat pAP̃|[OɂׂȂ̂
    // !!! Linux ̎Qlɂ邱

    do {
      if (timeout > 0) {
	COMMTIMEOUTS pcto;
	GetCommTimeouts(hComm, &pcto);
	pcto.ReadIntervalTimeout = 0;
	pcto.ReadTotalTimeoutConstant = timeout;
	pcto.ReadTotalTimeoutMultiplier = 0;
	SetCommTimeouts(hComm, &pcto);

      } else {
	// !!! ȉ̃R[h́AK؂ɓ삵ĂȂ\BČ
	DWORD dwErrors;
	COMSTAT ComStat;
	ClearCommError(hComm, &dwErrors, &ComStat);
	require_size = ((int)ComStat.cbInQue > require_size)
	  ? require_size : ComStat.cbInQue;
      }
      char data[BufferSize];
      int read_n = (require_size > BufferSize) ? BufferSize : require_size;
      DWORD n;
      ReadFile(hComm, data, read_n, &n, NULL);
      ring_buffer.put(data, n);
      filled += n;

      // vTCY𖞂܂ŁAf[^Ms
      if (pre_filled != filled) {
	pre_filled = filled;
      }
    } while ((timeout < 0) && (filled < size));
#endif
  }
};


SerialCtrl::SerialCtrl(void) : pimpl(new pImpl) {
}


SerialCtrl::~SerialCtrl(void) {
}


const char* SerialCtrl::what(void) {
  return pimpl->error_message.c_str();
}


bool SerialCtrl::connect(const char* device, long baudrate) {

  // ڑ
  if (strlen(device) >= 6) {
    // ȃfoCXƂ݂Ȃ
    // !!! G[ԂXVׂ
    return false;
  }
  char adjust_device[16];
  sprintf(adjust_device, "\\\\.\\%s", device);
  pimpl->hComm = CreateFile(adjust_device, GENERIC_READ | GENERIC_WRITE, 0,
			    NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);

  if (pimpl->hComm == INVALID_HANDLE_VALUE) {
#if 0
    LPVOID lpMsg;
    FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER |
		  FORMAT_MESSAGE_FROM_SYSTEM |
		  FORMAT_MESSAGE_IGNORE_INSERTS,
		  NULL, GetLastError(),
		  MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
		  (LPTSTR)&lpMsg, 0, NULL);
#endif
    char buffer[256];

    //DWORD error = GetLastError();
    // !!! lpMsg ̎ǵAۗB荞
    //sprintf(buffer, "port(%s) open failed: %s\n", device); //, lpMsg);
    sprintf(buffer, "port(%s) open failed\n", device); //, lpMsg);
    pimpl->error_message = buffer;
    //LocalFree(lpMsg);
    return false;
  }

  // {[[gݒ
  bool ret = pimpl->changeBaudrate(baudrate);
  if (ret == false) {
    return false;
  }
  pimpl->error_message = "no error";

  return true;
}


void SerialCtrl::disconnect(void) {
  pimpl->disconnect();
}


bool SerialCtrl::isConnected(void) {
  return (pimpl->hComm == INVALID_HANDLE_VALUE) ? false : true;
}


bool SerialCtrl::changeBaudrate(long baudrate) {
  return pimpl->changeBaudrate(baudrate);
}


int SerialCtrl::send(const char* data, int size) {
  if (isConnected() == false) {
    return 0;
  }

  DWORD n;
  WriteFile(pimpl->hComm, data, size, &n, NULL);
  return n;
}


int SerialCtrl::recv(char* data, int size, int timeout) {
  //printf("win recv.\n");
  if ((isConnected() == false) || (size <= 0)) {
    return 0;
  }

  // vMf[^΁AԂ
  int filled = SerialCtrl::size();
  if (filled >= size) {
    pimpl->ring_buffer.get(data, size);
    return size;
  }

  // Młf[^Ԃ
  int left = size - filled;
  pimpl->update(timeout, left);

  // size() ĂԂ update(0) Ă΂邽
  filled = pimpl->ring_buffer.size();
  pimpl->ring_buffer.get(data, filled);

  return filled;
}


int SerialCtrl::size(int timeout) {
  pimpl->update(timeout);
  return pimpl->ring_buffer.size();
}


void SerialCtrl::clear(void) {
  pimpl->update(0);
  pimpl->ring_buffer.clear();
}


void SerialCtrl::skip(int timeout) {
  clear();

  char buffer[BUFSIZ];
  int total = 0;
  int n;

  enum { EachTimeout = 10 };
  do {
    n = recv(buffer, BUFSIZ, EachTimeout);
    total += EachTimeout;
  } while ((n > 0) && ((timeout > 0) && (total < timeout)));
}


void SerialCtrl::flush(void) {
  FlushFileBuffers(pimpl->hComm);
}
