/*!
  \file
  \brief iԍɂڑ

  \author Satofumi KAMIMURA

  $Id$
*/

#include "ConnectionDeviceSearch.h"
#include "ProductIdHandler.h"
#include <string>
#include <algorithm>


struct ConnectionDeviceSearch::pImpl {
  typedef std::vector<std::string> DeviceList;
  DeviceList devices;
};


ConnectionDeviceSearch::ConnectionDeviceSearch(void) : pimpl(new pImpl) {
}


ConnectionDeviceSearch::~ConnectionDeviceSearch(void) {
}


void ConnectionDeviceSearch::add(const char* device) {
  pimpl->devices.push_back(device);
}


void ConnectionDeviceSearch::remove(const char* device) {
  pImpl::DeviceList::iterator p =
    find(pimpl->devices.begin(), pimpl->devices.end(), device);
  if (p == pimpl->devices.end()) {
    return;
  }

  // 폜
  pimpl->devices.erase(p);
}


void ConnectionDeviceSearch::clear(void) {
  pimpl->devices.clear();
}


size_t ConnectionDeviceSearch::getLeftDevices(std::vector<std::string>&
					      devices) {
  devices = pimpl->devices;
  return pimpl->devices.size();
}


bool ConnectionDeviceSearch::search(std::string& find_device,
				    const ProductIdHandler* handler,
				    const char* productId) {

  for (pImpl::DeviceList::iterator it = pimpl->devices.begin();
       it != pimpl->devices.end(); ++it) {
    const char* try_device = it->c_str();
    if (handler->checkProductId(it->c_str(), productId)) {
      find_device = try_device;
      remove(find_device.c_str());
      return true;
    }
  }
  return false;
}


size_t ConnectionDeviceSearch::size(void) {
  return pimpl->devices.size();
}
