/*!
  \example
  \brief AXL̃Tv

  \author Satofumi KAMIMURA

  $Id$
*/

#include "UrgCtrl.h"
#include "Delay.h"
#include <SDL.h>


int main(int argc, char *argv[]) {

  // œnꂽfoCXp
  const char* device = "/dev/ttyACM0";
  if (argc > 1) {
    device = argv[1];
  }

  // ZTƂ̐ڑ
  UrgCtrl urg;
  if (! urg.connect(device)) {
    printf("UrgCtrl::connect: %s\n", urg.what());
    exit(1);
  }
  urg.setCaptureMode(UrgCtrl::AutoCapture);

  // f[^̎M
  enum { TryTimes = 10 };
  int data_max = urg.getMaxDataLength();
  long* data = new long[data_max];
  int delay_msec = urg.getScanMsec();
  for (int i = 0; i < TryTimes; ++i) {
    delay(delay_msec);

    // f[^̊i[
    int n = urg.capture(data, data_max);
    if (n <= 0) {
      // f[^MȂ΁A΂炭ҋ@čēxf[^擾s
      continue;
    }
    // ʃf[^ƃ^CX^v\
    unsigned long ticks = urg.getRawTimestamp();
    printf("ticks: %ld, length: %ld\n", ticks, data[data_max / 2]);
  }
  delete [] data;

  return 0;
}
