/*!
  \file
  \brief xԂ𐧌\ delay() ֐

  \author Satofumi KAMIMURA

  $Id$
*/

#include "Delay.h"
#include "SdlInit.h"
#include "DetectOS.h"
#ifdef MSC
#include "SDL_win.h"
#else
#include <SDL.h>
#endif


static double WaitRatio = 1.0;
static SDL_mutex* Mutex = NULL;

/*!
  \brief SdlInit ̏NX
*/
class SdlInitClass : private SdlInit {
};

static void mutexInitialize(void) {
  static SdlInitClass sdl_init;
  static SDL_mutex* obj = SDL_CreateMutex();
  if (Mutex == NULL) {
    Mutex = obj;
  }
}


/*!
  \brief ҋ@֐

  w莞Ԃҋ@B

  \param msec [i] ҋ@ [msec]
*/
void delay(unsigned long msec) {
  mutexInitialize();

  SDL_LockMutex(Mutex);
  unsigned long delay_msec =
    static_cast<unsigned long>(msec * WaitRatio);
  SDL_UnlockMutex(Mutex);

  SDL_Delay(delay_msec);
}


/*!
  \brief Ԃ̐is䗦ݒ

  j^@\ɂāAȂǂ̂ɗpB

  \param ratio [i] Ԃ̂݋B2.0 ƂQ{
*/
void setDelayRatio(double ratio) {
  mutexInitialize();

  SDL_LockMutex(Mutex);
  WaitRatio = ratio;
  SDL_UnlockMutex(Mutex);
}
