#ifndef CONNECTION_DEVICE_SEARCH_H
#define CONNECTION_DEVICE_SEARCH_H

/*!
  \page connection_device_search_page VA ID w̃foCXT

  \section connection_device_search_section_abst Tv

  VA ID wɂāAڑfoCXTo߂̋@\BfoCXɂāAȉ̂ǂ炩p\B
    - foCXɃVA ID w肵A̔ʂ܂ŉ\ȃNX
    - iɃVA ID Ȃ߁ÃfoCX̔ʂ܂ŉ\ȃNX

  \n
  \section connection_device_search_section_list p\ȃfoCXpNX
  - VA ID 𗘗p̔ʂ܂ł\ȃNX
    - UrgCtrl (URG, Top-URG)
  \n \n
  - foCX̔ʂ܂ł\ȃNX
    - RunCtrl
    - Pgm238Ctrl
    - Tds01vCtrl

  \n
  \section connection_device_search_section_usage g

  URG ɁAp@܂BURG ̏ꍇAfoCXʂ邽߂̃NXƂāAUrgIdHandler p܂B

  -# foCX̃VA ID mF (Ql \ref miniterm_page)
\verbatim
% miniterm
VV
V
00P
VEND:Hokuyo Automatic Co.,Ltd.
PROD:SOKUIKI Sensor URG-04LX
FIRM:0.2.72g,06/06/02(20-5500[mm],240[deg],44-725[step],600[rpm])
PROT:00003,(SCIP 2.0)
SERI:H0614967
STAT:FW-dt WF:22mErCheck[FinDis with shadow   ]
\endverbatim
  \n
  ̃foCX̃VA ID ́uH0614967vł邱Ƃ킩܂B
  \n \n
  -# foCXõvOŁAVA ID wŃfoCXT
  \include urgIdHandlerSample.cpp
*/


/*!
  \file
  \brief iԍɂڑ

  \author Satofumi KAMIMURA

  $Id$
*/

#include <memory>
#include <vector>

class ConnectionInterface;
class ProductIdHandler;


/*!
  \brief ڑfoCX̒TNX

  o^ĂfoCX̒AΏۃfoCXTB
 */
class ConnectionDeviceSearch {
  ConnectionDeviceSearch(const ConnectionDeviceSearch& rhs);
  ConnectionDeviceSearch& operator = (const ConnectionDeviceSearch& rhs);

  struct pImpl;
  const std::auto_ptr<pImpl> pimpl;

public:
  ConnectionDeviceSearch(void);
  ~ConnectionDeviceSearch(void);

  /*!
    \brief ڑfoCX̓o^

    \param device[i] ڑfoCX
  */
  void add(const char* device);

  /*!
    \brief ڑfoCX̓o^폜

    \param device [i] o^폜foCX

    \attention TňvfoCX͌₩폜邽߁A[U瓮Iɍ폜Kv͂ȂB
  */
  void remove(const char* device);

  /*!
    \brief ڑfoCX̃NA
  */
  void clear(void);

  /*!
    \brief 蓖Ă̐ڑfoCXԂ

    \param devices [o] 蓖Ă̐ڑfoCX

    \return 蓖Ă̐ڑfoCX̌
  */
  size_t getLeftDevices(std::vector<std::string>& devices);

  /*!
    \brief ڑfoCX̒T

    \param find_device [o] vfoCX
    \param handler [i] TsfoCX̃nh
    \param productId [i] TfoCX̃VA ID

    \retval true TɐBfind_device ɌfoCXĕԂ
    \retval false Ts
  */
  bool search(std::string& find_device, const ProductIdHandler* handler,
	      const char* productId = "");

  /*!
    \brief ڑ̃foCXo^

    \return ڑ̃foCXo^
  */
  size_t size(void);
};

#endif /* !CONNECTION_DEVICE_SEARCH_H */
