/*!
  \example
  \brief o[W̕\Tv

  \author Satofumi KAMIMURA

  $Id$
*/

#include "UrgCtrl.h"
#include <SDL.h>


int main(int argc, char *argv[]) {

  const char device[] = "/dev/ttyACM0";

  UrgCtrl urg;
  if (! urg.connect(device)) {
    printf("UrgCtrl::connect: %s\n", urg.what());
    exit(1);
  }

  std::vector<std::string> lines;
  if (! urg.getVersionInfo(lines)) {
    printf("UrgCtrl::getVersionInfo: %s\n", urg.what());
    exit(1);
  }

  for (std::vector<std::string>::iterator it = lines.begin();
       it != lines.end(); ++it) {
    printf("%s\n", it->c_str());
  }

  return 0;
}
