/*!
  \file
  \brief t@C̃pXT

  \author Satofumi KAMIMURA

  $Id$
*/

#include "SearchFilePath.h"
#include "DetectOS.h"
#if defined LINUX_OS || defined Cygwin
#include <unistd.h>
#else
#include <windows.h>
#include <direct.h>
#include <io.h>
#ifndef F_OK
#define F_OK 06
#endif
#ifndef W_OK
#define W_OK 06
#endif
#endif


bool searchFilePath(std::string& full_path, const char* fname,
		    const std::vector<std::string>& dir_path) {

  // t@C݂̑ɊmF
  std::vector<std::string> search_dir = dir_path;
  if (search_dir.empty()) {
    search_dir.push_back(".");
  }
  for (std::vector<std::string>::const_iterator it = search_dir.begin();
       it != search_dir.end(); ++it) {

    // "~/" ϐ HOME ̓eɒu
    std::string replaced = *it;

    size_t match_index = it->find("~/");
    if (match_index != std::string::npos) {
      const char* home = getenv("HOME");
      if (home != NULL) {
	size_t n = strlen(home);
	replaced.replace(match_index, 1, home, n);
      }
    }
    std::string try_path = replaced + "/" + fname;
    if (access(try_path.c_str(), F_OK) == 0) {
      full_path = try_path;
      return true;
    }
  }
  return false;
}
