#ifndef POINTER_RING_BUFFER_H
#define POINTER_RING_BUFFER_H

/*!
  \file
  \brief |C^p̃Oobt@

  \author Satofumi KAMIMURA

  $Id$
*/

#include <deque>


/*!
  \brief |C^p̃Oobt@
*/
template<class T> class PointerRingBuffer {
  PointerRingBuffer(const PointerRingBuffer& rhs);
  PointerRingBuffer& operator = (const PointerRingBuffer& rhs);

  std::deque<T> ring_buffer;
  size_t filled;

public:
  PointerRingBuffer(void) : filled(0) {
  }

  ~PointerRingBuffer(void) {
  }

  size_t capacity(void) {
    return ring_buffer.size();
  }

  size_t size(void) {
    return filled;
  }

  T front(void) {
    return ring_buffer.front();
  }

  void push_buffer(T buffer) {
    ring_buffer.push_back(buffer);
  }

  T get_buffer(void) {
    T ret = ring_buffer[filled++];
    return ret;
  }

  void revert_buffer(void) {
    --filled;
  }

  void rotate(void) {
    T first = front();
    ring_buffer.pop_front();
    --filled;

    ring_buffer.push_back(first);
  }

  void clear(void) {
    filled = 0;
  }
};

#endif /* !POINTER_RING_BUFFER_H */
