#ifndef SERIAL_CTRL_H
#define SERIAL_CTRL_H

/*!
  \file
  \brief VAڑ

  \author Satofumi KAMIMURA

  $Id$
*/

#include "ConnectionInterface.h"
#include <memory>


/*!
  \brief VAʐMnh
*/
class SerialCtrl : public ConnectionInterface {
  SerialCtrl(const SerialCtrl& rhs);
  SerialCtrl& operator = (const SerialCtrl& rhs);

  struct pImpl;
  const std::auto_ptr<pImpl> pimpl;

public:
  enum { NoTimeout = -1 };

  explicit SerialCtrl(void);
  ~SerialCtrl(void);

  const char* what(void);
  int connect(const char* device, long baudrate);
  void disconnect(void);
  bool isConnected(void);
  int changeBaudrate(long baudrate);
  int send(const char* data, int size);
  int recv(char* data, int size, int timeout);
  int getLine(std::string& data, int timeout);
  int size(void);
  void clear(void);
  void skip(int timeout = NoTimeout);
};

#endif /* !SERIAL_CTRL_H */
