/*!
  \file
  \brief t@C擾

  \author Satofumi KAMIMURA

  $Id$
*/

#include "FileToArgs.h"
#include <string>
#include <fstream>
#include <vector>
#include <map>
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#if !HAVE_CONFIG_H || defined(HAVE_BOOST_REGEX)
#include <boost/regex.hpp>
#endif


struct FileToArgs::pImpl {
  std::vector<std::string> args;
  std::vector<char*> argv_ptr;
  typedef std::map<std::string,size_t> TagMap;
  TagMap tag_map;

  bool parseLine(std::string& line, const char* programName) {

    if (line.empty()) {
      return false;
    }

    if (line[0] == '#') {
      return false;
    }

    // !!! strtok() ͒uׂȁH
    // !!! Boost?
    const char* token = strtok(const_cast<char*>(line.c_str()), " \t\r\n");
    if (token == NULL) {
      return false;
    }
    const char* next_token = strtok(NULL, " \t\r\n");
    if (next_token == NULL) {
      line = token;
      return true;
    }

    // g[NQȏ゠ꍇ̏
#if !HAVE_CONFIG_H || defined(HAVE_BOOST_REGEX)
    boost::regex pattern(token);
    if (! boost::regex_match(programName, pattern)) {
      return false;
    }
#else
    if (strcmp(token, programName)) {
      return false;
    }
#endif
    line = next_token;
    return true;
  }
};


FileToArgs::FileToArgs(void) : pimpl(new pImpl), argc(0) {
}


FileToArgs::~FileToArgs(void) {
}


void FileToArgs::load(const char* fname, const char* programName) {
  pimpl->args.clear();
  argc = 0;

  // ŏɃvOi[
  pimpl->args.push_back(programName);

  // t@CJ
  std::ifstream fin(fname);
  if (! fin.is_open()) {
    return;
  }

  while (! fin.eof()) {

    // s̏ƂĈ
    std::string line;
    getline(fin, line);

    if (! pimpl->parseLine(line, programName)) {
      continue;
    }

    // '=' ܂ł̃^OdAォ̓eŏ㏑
    //const char* tag = strtok(const_cast<char*>(dup_line.c_str()), "=");
    size_t tag_size = line.find('=');
    if (tag_size != std::string::npos) {
      std::string tag = line.substr(0, tag_size);
      pImpl::TagMap::iterator p = pimpl->tag_map.find(tag);
      if (p != pimpl->tag_map.end()) {
	size_t find_index = p->second;
	pimpl->args[find_index] = line;
	continue;
      } else {
	size_t insert_index = pimpl->args.size();
	pimpl->tag_map.insert(std::pair<std::string,size_t>(tag,
							    insert_index));
      }
    }

    pimpl->args.push_back(line);
  }

  // argc, argv ̐
  for (std::vector<std::string>::iterator it = pimpl->args.begin();
       it != pimpl->args.end(); ++it) {
    pimpl->argv_ptr.push_back(&(*it)[0]);
  }
  argc = pimpl->args.size();
  argv = &(pimpl->argv_ptr)[0];
}
