#ifndef F_ZTAT_HANDLER_H
#define F_ZTAT_HANDLER_H

/*!
  \file
  \brief F-ZTAT ̊Ǘ

  \author Satofumi KAMIMURA

  $Id$
*/

#include <memory>

class SFormatHandler;
class ConnectionInterface;


class FZtatHandler {
  FZtatHandler(const FZtatHandler& rhs);
  FZtatHandler& operator = (const FZtatHandler& rhs);

  struct pImpl;
  const std::auto_ptr<pImpl> pimpl;

public:
  FZtatHandler(void);
  ~FZtatHandler(void);

  const char* what(void);

  ConnectionInterface*& getConnection(void);
  void setTargetCpu(const char* type);
  bool connect(const char* serialDevice, long baudrate);
  bool write(SFormatHandler& sformat);
  bool sendSrecData(SFormatHandler& sformat);
  bool sendStartAddress(void);
};

#endif /* !F_ZTAT_HANDLER_H */
