/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.kino.plugin.beangenerator;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Properties;
import nu.mine.kino.plugin.beangenerator.Activator;
import nu.mine.kino.plugin.beangenerator.Messages;
import nu.mine.kino.plugin.beangenerator.sheetdata.IClassInformation;
import org.apache.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;

public class JavaBeansReaderCreator {
    private static final Logger logger = Logger.getLogger(JavaBeansReaderCreator.class);
    private final IJavaProject javaProject;

    public JavaBeansReaderCreator(IJavaProject javaProject) {
        this.javaProject = javaProject;
        URL entry = Activator.getDefault().getBundle().getEntry("/");
        try {
            String pluginDirectory = FileLocator.resolve((URL)entry).getPath();
            File file = new File(pluginDirectory, "lib");
            Properties p = new Properties();
            p.setProperty("file.resource.loader.path", file.getAbsolutePath());
            Velocity.init((Properties)p);
        }
        catch (IOException e) {
            logger.error((Object)"JavaBeansReaderCreator()", (Throwable)e);
            Activator.logException(e);
        }
        catch (Exception e) {
            logger.error((Object)"JavaBeansReaderCreator()", (Throwable)e);
            Activator.logException(e);
        }
    }

    public ICompilationUnit create(IClassInformation info) throws CoreException {
        logger.debug((Object)"create(ClassInformation) - start");
        IPackageFragmentRoot root = this.getSourceDir(this.javaProject);
        String pkg = info.getPackageName();
        IPackageFragment pack = root.getPackageFragment(pkg);
        if (!pack.exists()) {
            pack = root.createPackageFragment(pkg, true, (IProgressMonitor)new NullProgressMonitor());
        }
        String mainStatement = this.createMain(info);
        ICompilationUnit cu = pack.createCompilationUnit(String.valueOf(info.getClassName()) + "Sheet.java", mainStatement, true, (IProgressMonitor)new NullProgressMonitor());
        cu.save((IProgressMonitor)new NullProgressMonitor(), true);
        logger.debug((Object)"create(ClassInformation) - end");
        return cu;
    }

    private String executeVelocity(String vm, String[] names, Object[] objs) throws CoreException {
        logger.debug((Object)"executeVelocity(String, String[], Object[]) - start");
        try {
            VelocityContext context = new VelocityContext();
            int i = 0;
            while (i < names.length) {
                context.put(names[i], objs[i]);
                ++i;
            }
            StringWriter out = new StringWriter();
            Template template = Velocity.getTemplate((String)vm, (String)"MS932");
            template.merge((Context)context, (Writer)out);
            String result = out.toString();
            out.flush();
            logger.debug((Object)"executeVelocity(String, String[], Object[]) - end");
            return result;
        }
        catch (Exception e) {
            logger.error((Object)"executeVelocity(String, String[], Object[])", (Throwable)e);
            Status status = new Status(4, Activator.getPluginId(), 0, e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private String createMain(IClassInformation clazz) throws CoreException {
        return this.executeVelocity("reader.vm", new String[]{"class"}, new IClassInformation[]{clazz});
    }

    private boolean contains(String input, String ... strs) {
        String[] stringArray = strs;
        int n = strs.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (input.equals(str)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private IPackageFragmentRoot getSourceDir(IJavaProject javaProject) throws CoreException {
        IPackageFragmentRoot[] roots;
        IPackageFragmentRoot[] iPackageFragmentRootArray = roots = javaProject.getPackageFragmentRoots();
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            if (root.getKind() == 1) {
                return root;
            }
            ++n2;
        }
        Status status = new Status(4, Activator.getPluginId(), 0, Messages.JavaBeansCreator_MSG_SRCDIR_NOT_FOUND, null);
        throw new CoreException((IStatus)status);
    }
}

