package jp.sf.beanbinder.petstore.view;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import java.text.Format;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

import jp.sf.beanbinder.BeanBinder;
import jp.sf.beanbinder.BeanBinderFactory;
import jp.sf.beanbinder.annotations.AlignType;
import jp.sf.beanbinder.annotations.AnnotationParser;
import jp.sf.beanbinder.annotations.Basic;
import jp.sf.beanbinder.annotations.Column;
import jp.sf.beanbinder.annotations.Table;
import jp.sf.beanbinder.component.swing.PictureBox;
import jp.sf.beanbinder.petstore.controller.AddItem;
import jp.sf.beanbinder.petstore.controller.Clear;
import jp.sf.beanbinder.petstore.controller.Command;
import jp.sf.beanbinder.petstore.controller.PickCategory;
import jp.sf.beanbinder.petstore.controller.PickItem;
import jp.sf.beanbinder.petstore.controller.Submit;
import jp.sf.beanbinder.validator.NumberValidator;
import jp.sf.beanbinder.validator.ValidateDisplay;
import jp.sf.beanbinder.validator.Validator;
import jp.sf.beanbinder.validator.swing.SwingValidateDisplay;

public class ShoppingWindow extends JFrame implements MouseListener, ActionListener {
    public BeanBinder binder = BeanBinderFactory.createSwingBinder();
    private Command pickCategory = new PickCategory();  //  @jve:decl-index=0:
    private Command pickItem = new PickItem();
    private Command addItem = new AddItem();
    private Command clear = new Clear();
    private Command submit = new Submit();
    
    //フォーマット
    private Format fmt1 = new DecimalFormat("###,###,###");
    
    //Validator
    private ValidateDisplay display = new SwingValidateDisplay(this);
    private Validator qtyValidator = new NumberValidator("数量は数値を入力して下さい。", display);
    
    //明細行
    @Table( objectKey="order.itemDetails", columns={
            @Column( prop="item.code", text="コード", readOnly=true ),
            @Column( prop="item.name", text="品名", readOnly=true ),
            @Column( prop="item.unitPrice", text="単価", formatField="fmt1", horizon=AlignType.RIGHT, readOnly=true ),
            @Column( prop="qty", text="数量", formatField="fmt1", horizon=AlignType.RIGHT ),
            @Column( prop="totalPrice", text="合計", formatField="fmt1", horizon=AlignType.RIGHT, readOnly=true )
        }
    )
    private JTable jTable = null;
    
    //商品カテゴリ一覧
    @Table( objectKey="categoryList",
            columns={ @Column(prop="name", text="名称", readOnly=true) }
    )
    private JTable jTable1 = null;
    
    //商品一覧
    @Table( objectKey="itemList", columns={
            @Column( prop="code", text="コード", readOnly=true ),
            @Column( prop="name", text="名称", readOnly=true ),
            @Column( prop="unitPrice", text="単価", formatField="fmt1", horizon=AlignType.RIGHT, readOnly=true )
    })
    private JTable jTable2 = null;
    
    //数量入力
    @Basic( objectKey="qty", prop="value", validatorField="qtyValidator" )
    private JTextField qtyTextBox = null;

    //小計
    @Basic( objectKey="order", prop="totalPrice", formatField="fmt1", horizon=AlignType.RIGHT )
    private JTextField totalTextBox = null;

    //消費税
    @Basic( objectKey="order", prop="tax", formatField="fmt1", horizon=AlignType.RIGHT )
    private JTextField taxTextBox = null;

    //合計
    @Basic( objectKey="order", prop="gross", formatField="fmt1", horizon=AlignType.RIGHT )
    private JTextField grossTextBox = null;

    //商品・カテゴリの画像
    @Basic( objectKey="info", prop="image" )
    private PictureBox pictureBox = null;

    //商品・カテゴリのタイトル
    @Basic( objectKey="info", prop="title" )
    private JLabel titleLabel = null;
    
    
    //以下の多くはVisualEditorによって生成されています。
    private static final long serialVersionUID = 1L;

    private JPanel jContentPane = null;

    private JPanel mainPanel = null;

    private JPanel controlPanel = null;

    private JScrollPane jScrollPane = null;

    
    private JSplitPane jSplitPane = null;

    private JPanel detailPanel = null;

    private JScrollPane jScrollPane1 = null;

    private JButton submitButton = null;

    private JLabel jLabel = null;

    private JLabel jLabel1 = null;

    private JLabel jLabel2 = null;

    private JLabel label1 = null;

    private JLabel label2 = null;

    private JButton clearButton = null;

    private JPanel jPanel = null;

    private JPanel jPanel1 = null;

    private JLabel jLabel3 = null;

    private JButton addButton = null;

    private JSplitPane jSplitPane1 = null;
    private JPanel jPanel2 = null;
    private JScrollPane jScrollPane2 = null;

    /**
     * This is the default constructor
     */
    public ShoppingWindow() {
        super();
        initialize();

        //アノテーションからマッピング
        new AnnotationParser(this.binder, this).parse();
        
        //リスナー
        this.getJTable1().addMouseListener(this);
        this.getJTable2().addMouseListener(this);
        this.getAddButton().addActionListener(this);
        this.getClearButton().addActionListener(this);
        this.getSubmitButton().addActionListener(this);
        this.getJTable().getModel().addTableModelListener(new TableModelListener() {
            public void tableChanged(TableModelEvent e) {
                binder.updateComponent("totalTextBox");
                binder.updateComponent("taxTextBox");
                binder.updateComponent("grossTextBox");
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        //商品の追加
        if( e.getSource().equals(this.getAddButton()) ) {
            this.addItem.execute(this.binder);
        }
        //クリア
        if( e.getSource().equals(this.getClearButton()) ) {
            this.clear.execute(this.binder);
        }
        //購入
        if( e.getSource().equals(this.getSubmitButton()) ) {
            this.submit.execute(this.binder);
        }
    }
    public void mouseClicked(MouseEvent e) {
        //商品の選択
        if( e.getSource().equals(this.getJTable2()) ) {
            this.pickItem.execute(this.binder);
        }
        //カテゴリの選択
        if( e.getSource().equals(this.getJTable1()) ) {
            this.pickCategory.execute(this.binder);
        }
    }
    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {}
    public void mousePressed(MouseEvent e) {}
    public void mouseReleased(MouseEvent e) {}
    
    /**
     * This method initializes this
     * 
     * @return void
     */
    private void initialize() {
        this.setContentPane(getJContentPane());
        this.setResizable(false);
        this.setBounds(new Rectangle(0, 0, 800, 480));
        this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        this.setTitle("SmallPetStore");
    }

    /**
     * This method initializes jContentPane
     * 
     * @return javax.swing.JPanel
     */
    private JPanel getJContentPane() {
        if (jContentPane == null) {
            jContentPane = new JPanel();
            jContentPane.setLayout(new BorderLayout());
            jContentPane.add(getMainPanel(), BorderLayout.NORTH);
            jContentPane.add(getControlPanel(), BorderLayout.SOUTH);
            jContentPane.add(getJScrollPane(), BorderLayout.CENTER);
        }
        return jContentPane;
    }

    /**
     * This method initializes mainPanel	
     * 	
     * @return javax.swing.JPanel	
     */
    private JPanel getMainPanel() {
        if (mainPanel == null) {
            mainPanel = new JPanel();
            mainPanel.setLayout(new BorderLayout());
            mainPanel.setPreferredSize(new Dimension(0, 180));
            mainPanel.add(getJSplitPane(), BorderLayout.CENTER);
        }
        return mainPanel;
    }

    /**
     * This method initializes controlPanel	
     * 	
     * @return javax.swing.JPanel	
     */
    private JPanel getControlPanel() {
        if (controlPanel == null) {
            jLabel2 = new JLabel();
            jLabel2.setBounds(new Rectangle(650, 10, 41, 21));
            jLabel2.setHorizontalAlignment(SwingConstants.CENTER);
            jLabel2.setText("請求額");
            jLabel1 = new JLabel();
            jLabel1.setBounds(new Rectangle(510, 10, 41, 21));
            jLabel1.setHorizontalAlignment(SwingConstants.CENTER);
            jLabel1.setText("消費税");
            jLabel = new JLabel();
            jLabel.setBounds(new Rectangle(370, 10, 41, 21));
            jLabel.setHorizontalAlignment(SwingConstants.CENTER);
            jLabel.setText("小計");
            controlPanel = new JPanel();
            controlPanel.setLayout(null);
            controlPanel.setPreferredSize(new Dimension(0, 80));
            controlPanel.add(getSubmitButton(), null);
            controlPanel.add(jLabel, null);
            controlPanel.add(jLabel1, null);
            controlPanel.add(jLabel2, null);
            controlPanel.add(getTotalTextBox(), null);
            controlPanel.add(getTaxTextBox(), null);
            controlPanel.add(getGrossTextBox(), null);
            controlPanel.add(getClearButton(), null);
        }
        return controlPanel;
    }

    /**
     * This method initializes jScrollPane	
     * 	
     * @return javax.swing.JScrollPane	
     */
    private JScrollPane getJScrollPane() {
        if (jScrollPane == null) {
            jScrollPane = new JScrollPane();
            jScrollPane.setViewportView(getJTable());
        }
        return jScrollPane;
    }

    /**
     * This method initializes jTable	
     * 	
     * @return javax.swing.JTable	
     */
    private JTable getJTable() {
        if (jTable == null) {
            jTable = new JTable();
        }
        return jTable;
    }

    /**
     * This method initializes jSplitPane	
     * 	
     * @return javax.swing.JSplitPane	
     */
    private JSplitPane getJSplitPane() {
        if (jSplitPane == null) {
            jSplitPane = new JSplitPane();
            jSplitPane.setDividerLocation(320);
            jSplitPane.setRightComponent(getJPanel());
            jSplitPane.setLeftComponent(getDetailPanel());
        }
        return jSplitPane;
    }

    /**
     * This method initializes detailPanel	
     * 	
     * @return javax.swing.JPanel	
     */
    private JPanel getDetailPanel() {
        if (detailPanel == null) {
            label2 = new JLabel();
            label2.setBounds(new Rectangle(140, 110, 171, 21));
            label2.setText("");
            label1 = new JLabel();
            label1.setBounds(new Rectangle(140, 60, 171, 21));
            label1.setText("");
            titleLabel = new JLabel();
            titleLabel.setBounds(new Rectangle(140, 10, 171, 21));
            titleLabel.setFont(new Font("Dialog", Font.BOLD, 18));
            titleLabel.setText("");
            detailPanel = new JPanel();
            detailPanel.setLayout(null);
            detailPanel.setPreferredSize(new Dimension(320, 0));
            detailPanel.add(getPictureBox(), null);
            detailPanel.add(titleLabel, null);
            detailPanel.add(label1, null);
            detailPanel.add(label2, null);
        }
        return detailPanel;
    }

    /**
     * This method initializes jScrollPane1	
     * 	
     * @return javax.swing.JScrollPane	
     */
    private JScrollPane getJScrollPane1() {
        if (jScrollPane1 == null) {
            jScrollPane1 = new JScrollPane();
            jScrollPane1.setViewportView(getJTable1());
        }
        return jScrollPane1;
    }

    /**
     * This method initializes jTable1	
     * 	
     * @return javax.swing.JTable	
     */
    private JTable getJTable1() {
        if (jTable1 == null) {
            jTable1 = new JTable();
        }
        return jTable1;
    }

    /**
     * This method initializes submitButton	
     * 	
     * @return javax.swing.JButton	
     */
    private JButton getSubmitButton() {
        if (submitButton == null) {
            submitButton = new JButton();
            submitButton.setBounds(new Rectangle(660, 50, 121, 21));
            submitButton.setText("購入");
        }
        return submitButton;
    }

    /**
     * This method initializes totalTextBox	
     * 	
     * @return javax.swing.JTextField	
     */
    private JTextField getTotalTextBox() {
        if (totalTextBox == null) {
            totalTextBox = new JTextField();
            totalTextBox.setBounds(new Rectangle(420, 10, 81, 21));
        }
        return totalTextBox;
    }

    /**
     * This method initializes taxTextBox	
     * 	
     * @return javax.swing.JTextField	
     */
    private JTextField getTaxTextBox() {
        if (taxTextBox == null) {
            taxTextBox = new JTextField();
            taxTextBox.setBounds(new Rectangle(560, 10, 81, 21));
        }
        return taxTextBox;
    }

    /**
     * This method initializes grossTextBox	
     * 	
     * @return javax.swing.JTextField	
     */
    private JTextField getGrossTextBox() {
        if (grossTextBox == null) {
            grossTextBox = new JTextField();
            grossTextBox.setBounds(new Rectangle(700, 10, 81, 21));
        }
        return grossTextBox;
    }

    /**
     * This method initializes pictureBox	
     * 	
     * @return jp.sf.beanbinder.swing.component.PictureBox	
     */
    private PictureBox getPictureBox() {
        if (pictureBox == null) {
            pictureBox = new PictureBox();
            pictureBox.setBounds(new Rectangle(10, 10, 121, 121));
        }
        return pictureBox;
    }

    /**
     * This method initializes clearButton	
     * 	
     * @return javax.swing.JButton	
     */
    private JButton getClearButton() {
        if (clearButton == null) {
            clearButton = new JButton();
            clearButton.setBounds(new Rectangle(560, 50, 91, 21));
            clearButton.setText("クリア");
        }
        return clearButton;
    }

    /**
     * This method initializes jPanel	
     * 	
     * @return javax.swing.JPanel	
     */
    private JPanel getJPanel() {
        if (jPanel == null) {
            jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.add(getJSplitPane1(), BorderLayout.CENTER);
        }
        return jPanel;
    }
    private JPanel getJPanel1() {
        if (jPanel1 == null) {
            jLabel3 = new JLabel();
            jLabel3.setBounds(new Rectangle(100, 10, 41, 21));
            jLabel3.setHorizontalAlignment(SwingConstants.CENTER);
            jLabel3.setText("数量");
            jPanel1 = new JPanel();
            jPanel1.setPreferredSize(new Dimension(0, 40));
            jPanel1.setLayout(null);
            jPanel1.add(jLabel3, null);
            jPanel1.add(getQtyTextBox(), null);
            jPanel1.add(getAddButton(), null);
        }
        return jPanel1;
    }

    /**
     * This method initializes qtyTextBox	
     * 	
     * @return javax.swing.JTextField	
     */
    private JTextField getQtyTextBox() {
        if (qtyTextBox == null) {
            qtyTextBox = new JTextField();
            qtyTextBox.setBounds(new Rectangle(150, 10, 61, 21));
        }
        return qtyTextBox;
    }

    /**
     * This method initializes addButton	
     * 	
     * @return javax.swing.JButton	
     */
    private JButton getAddButton() {
        if (addButton == null) {
            addButton = new JButton();
            addButton.setBounds(new Rectangle(220, 10, 61, 21));
            addButton.setText("追加");
        }
        return addButton;
    }

    /**
     * This method initializes jSplitPane1	
     * 	
     * @return javax.swing.JSplitPane	
     */
    private JSplitPane getJSplitPane1() {
        if (jSplitPane1 == null) {
            jSplitPane1 = new JSplitPane();
            jSplitPane1.setDividerLocation(140);
            jSplitPane1.setLeftComponent(getJScrollPane1());
            jSplitPane1.setRightComponent(getJPanel2());
        }
        return jSplitPane1;
    }

    /**
     * This method initializes jPanel2	
     * 	
     * @return javax.swing.JPanel	
     */
    private JPanel getJPanel2() {
        if (jPanel2 == null) {
            jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout());
            jPanel2.add(getJPanel1(), BorderLayout.SOUTH);
            jPanel2.add(getJScrollPane2(), BorderLayout.CENTER);
        }
        return jPanel2;
    }

    /**
     * This method initializes jScrollPane2	
     * 	
     * @return javax.swing.JScrollPane	
     */
    private JScrollPane getJScrollPane2() {
        if (jScrollPane2 == null) {
            jScrollPane2 = new JScrollPane();
            jScrollPane2.setViewportView(getJTable2());
        }
        return jScrollPane2;
    }

    /**
     * This method initializes jTable2	
     * 	
     * @return javax.swing.JTable	
     */
    private JTable getJTable2() {
        if (jTable2 == null) {
            jTable2 = new JTable();
        }
        return jTable2;
    }
}
