package jp.sf.beanbinder.petstore.test;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import jp.sf.beanbinder.petstore.model.Account;
import jp.sf.beanbinder.petstore.model.CreditCard;
import jp.sf.beanbinder.petstore.model.Item;
import jp.sf.beanbinder.petstore.model.ItemDetail;
import jp.sf.beanbinder.petstore.model.Order;
import junit.framework.TestCase;

public class OrderTest extends TestCase {
    public void testOrder() {
        //顧客
        Account account = new Account();
        account.setUserId("testusr");
        account.setPassword("pass123");
        
        //受注開始
        Order order = new Order();
        order.setCustomer(account); //取引先
        order.setBillto(account);   //請求先
        order.setShipto(account);   //お届先
        
        order.setHandlingCharge(new BigDecimal(0));//手数料
        order.setShippingCharge(new BigDecimal(0));//送料
        
        //支払方法はクレジットカードで
        CreditCard card = new CreditCard();
        card.setName("visa");
        card.setCardNumber("0000 0000 0000 0000");
        card.setExpirationYear("2007");
        card.setExpirationMonth("12");
        order.setPaymentMethod(card);
        
        //明細行
        Item item = this.getItemList().get(0);
        order.addItemDetail(item, new BigDecimal(2));
        
        item = this.getItemList().get(1);
        order.addItemDetail(item, new BigDecimal(1));
        
        //終了
        System.out.println( "-------------------受注書---------------------" );
        for(ItemDetail itemDetail : order.getItemDetails()) {
            System.out.print( itemDetail.getItem().getName()+" / " );
            System.out.print( "単価:"+itemDetail.getItem().getUnitPrice()+" / " );
            System.out.print( "数量:"+itemDetail.getQty().intValue()+" / " );
            System.out.print( "金額:"+itemDetail.getTotalPrice().intValue() + "\n" );
        }
        System.out.print( "送料:"+order.getShippingCharge().intValue()+"\n" );
        System.out.print( "手数料:"+order.getHandlingCharge().intValue()+"\n" );
        System.out.println( "---------------------------------------------" );
        System.out.print( "小計"+order.getTotalPrice().intValue()+"\n" );
        System.out.print( "消費税"+order.getTax().intValue()+"\n" );
        System.out.print( "請求額"+order.getGross().intValue()+"\n" );
        System.out.println( "---------------------------------------------" );
        
        assertEquals(order.getTotalPrice().intValue(), 3530);
        assertEquals(order.getTax().intValue(), 176);
        assertEquals(order.getGross().intValue(), 3706);
    }
    private List<Item> getItemList() {
        List<Item> list = new ArrayList<Item>();
        
        Item item = new Item();
        item.setName("テスト商品");
        item.setUnitPrice(new BigDecimal(1500));
        list.add(item);
        
        item = new Item();
        item.setName("テスト商品2");
        item.setUnitPrice(new BigDecimal(530));
        list.add(item);
        
        return list;
    }
}
