package jp.sf.beanbinder.petstore.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class Order implements Serializable {
    private Long id;
    private Account customer;
    private Person billto;
    private Person shipto;
    private PaymentMethod paymentMethod;                    //支払方法
    private BigDecimal taxRate = new BigDecimal(0.05);      //税率
    private BigDecimal handlingCharge = new BigDecimal(0);  //手数料
    private BigDecimal shippingCharge = new BigDecimal(0);  //送料
    private List<ItemDetail> itemDetails = new ArrayList<ItemDetail>();
    
    public BigDecimal getTotalPrice() {
        BigDecimal subtotal = new BigDecimal(0);
        for(ItemDetail itemDetail : this.itemDetails) {
            subtotal = subtotal.add(itemDetail.getTotalPrice());
        }
        return subtotal;
    }
    public BigDecimal getTax() {
        return this.getTotalPrice().multiply(this.taxRate).setScale(0,BigDecimal.ROUND_DOWN);
    }
    public BigDecimal getGross() {
        BigDecimal gross = this.getTotalPrice().add(this.getTax());
        gross = gross.add(this.handlingCharge);
        gross = gross.add(this.shippingCharge);
        return gross;
    }
    public void addItemDetail(Item item, BigDecimal qty) {
        ItemDetail itemDetail = new ItemDetail();
        itemDetail.setItem(item);
        itemDetail.setQty(qty);
        this.getItemDetails().add(itemDetail);
    }
    
    public Person getBillto() {
        return billto;
    }
    public void setBillto(Person billto) {
        this.billto = billto;
    }
    public Account getCustomer() {
        return customer;
    }
    public void setCustomer(Account customer) {
        this.customer = customer;
    }
    public Long getId() {
        return id;
    }
    public void setId(Long id) {
        this.id = id;
    }
    public List<ItemDetail> getItemDetails() {
        return itemDetails;
    }
    public void setItemDetails(List<ItemDetail> itemDetails) {
        this.itemDetails = itemDetails;
    }
    public Person getShipto() {
        return shipto;
    }
    public void setShipto(Person shipto) {
        this.shipto = shipto;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }
    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getHandlingCharge() {
        return handlingCharge;
    }
    public void setHandlingCharge(BigDecimal handlingCharge) {
        this.handlingCharge = handlingCharge;
    }
    public BigDecimal getShippingCharge() {
        return shippingCharge;
    }
    public void setShippingCharge(BigDecimal shippingCharge) {
        this.shippingCharge = shippingCharge;
    }
    public PaymentMethod getPaymentMethod() {
        return paymentMethod;
    }
    public void setPaymentMethod(PaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
    }
}
