package jp.sf.beanbinder.petstore;
import jp.sf.beanbinder.adapter.ObjectAdapter;
import jp.sf.beanbinder.petstore.dao.CategoryDao;
import jp.sf.beanbinder.petstore.dao.ItemDao;
import jp.sf.beanbinder.petstore.dao.mock.CategoryDaoImpl;
import jp.sf.beanbinder.petstore.dao.mock.ItemDaoImpl;
import jp.sf.beanbinder.petstore.model.Order;
import jp.sf.beanbinder.petstore.view.ShoppingWindow;


public class SmallPetStore {
    public static final CategoryDao categoryDao = new CategoryDaoImpl();
    public static final ItemDao itemDao = new ItemDaoImpl();
    
    public SmallPetStore() {
        ShoppingWindow window = new ShoppingWindow();
        
        try {
            Order order = new Order();
            window.binder.setObject("order", order);
            window.binder.setObject("categoryList", categoryDao.findAll());
            window.binder.setObject("qty", new ObjectAdapter(0));
            window.binder.updateComponent(".*");
        }catch(Exception e) {
            e.printStackTrace();
        }
        
        window.setVisible(true);
    }
    public static void main(String[] args) {
        new SmallPetStore();
    }
}
