/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.beanbinder.strategy.swing;

import java.util.Collection;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import jp.sf.beanbinder.Bind;
import jp.sf.beanbinder.BindProperty;
import jp.sf.beanbinder.strategy.swing.TableSorter;
import jp.sf.beanbinder.util.BeanProcessBridge;

public class JTableModel
extends DefaultTableModel {
    public Collection bean;
    private JTable table;
    public Bind bind;
    public boolean isFailedValidate = false;

    public JTableModel(JTable table, Collection bean, Bind bind) {
        this.bean = bean;
        this.table = table;
        this.bind = bind;
        int row = 0;
        while (row < bean.size()) {
            int col = 0;
            while (col < bind.getProperties().size()) {
                this.getDisplayValue(row, col);
                ++col;
            }
            ++row;
        }
    }

    public int getColumnCount() {
        return this.bind.getProperties().size();
    }

    public int getRowCount() {
        if (this.bean == null) {
            return 0;
        }
        return this.bean.size();
    }

    public Object getBean() {
        return this.bean;
    }

    public Object getValueAt(int row, int column) {
        Object obj = null;
        column = this.table.convertColumnIndexToModel(column);
        if (this.table.getModel() instanceof TableSorter) {
            TableSorter tableSorter = (TableSorter)this.table.getModel();
            row = tableSorter.modelIndex(row);
        } else {
            row = this.table.convertRowIndexToModel(row);
        }
        try {
            obj = BeanProcessBridge.getPropertyValue(this.bean.toArray()[row], this.bind.getProperty(column).getDisplayProperty());
            return this.bind.getProperty(column).getFormat().format(obj == null ? "" : obj);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object getProperty(int row, int column) {
        Object obj = null;
        try {
            obj = BeanProcessBridge.getPropertyValue(this.bean.toArray()[row], this.bind.getProperty(column).getDataSrc().getValueProp());
            return obj;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object getDisplayValue(int row, int column) {
        Object obj = null;
        try {
            obj = BeanProcessBridge.getPropertyValue(this.bean.toArray()[row], this.bind.getProperty(column).getDisplayProperty());
            return obj;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setValueAt(Object aValue, int row, int column) {
        this.isFailedValidate = false;
        Object obj = this.bean.toArray()[row];
        if (!this.bind.getProperty(column).getValidator().check(aValue, this.table)) {
            this.isFailedValidate = true;
            return;
        }
        try {
            BeanProcessBridge.setPropertyValue(obj, this.bind.getProperty(column).getRef().getValueProp(), aValue);
        }
        catch (Exception e) {
            throw new RuntimeException(obj + "=" + aValue + "/" + e);
        }
        this.fireTableDataChanged();
        this.table.repaint();
        int i = 0;
        while (i < this.bind.getProperties().size()) {
            if (i != column) {
                BindProperty prop = this.bind.getProperty(i);
                Object value = null;
                try {
                    value = BeanProcessBridge.getPropertyValue(obj, prop.getRef().getValueProp());
                }
                catch (Exception e) {
                    this.isFailedValidate = true;
                    return;
                }
                if (!prop.getValidator().check(value, this.table)) {
                    this.isFailedValidate = true;
                    return;
                }
            }
            ++i;
        }
    }

    public String getColumnName(int column) {
        String title = this.bind.getProperty(column).getColumnProperty().getText();
        return title == null ? String.valueOf(column) : title;
    }

    public boolean isCellEditable(int row, int column) {
        return this.bind.getProperty(column).isEditable();
    }
}

