/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.beanbinder.component.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class CalendarComponent
extends JPanel {
    private static final String[] columns = new String[]{"\u65e5", "\u6708", "\u706b", "\u6c34", "\u6728", "\u91d1", "\u571f"};
    private static final String[] month = new String[]{"1\u6708", "2\u6708", "3\u6708", "4\u6708", "5\u6708", "6\u6708", "7\u6708", "8\u6708", "9\u6708", "10\u6708", "11\u6708", "12\u6708"};
    private Calendar calendar = null;
    private int[][] tableData;
    private JTable jTable = new JTable();
    private JPanel jPanel;
    private JComboBox jComboBox;
    private JTextField jTextField;
    private JScrollBar jScrollBar;
    private Calendar result = null;
    static /* synthetic */ Class class$0;

    public Calendar getResult() {
        this.update();
        return this.result;
    }

    public JTable getCalendarTable() {
        return this.jTable;
    }

    public CalendarComponent() {
        this(Calendar.getInstance(Locale.JAPAN));
    }

    public CalendarComponent(Calendar c) {
        this.setSize(200, 300);
        this.jTable.setBounds(0, 0, 200, 280);
        this.jTable.setShowGrid(true);
        this.jTable.setShowHorizontalLines(true);
        this.jTable.setShowVerticalLines(true);
        this.jTable.setSelectionMode(0);
        this.jTable.setRowSelectionAllowed(false);
        this.jTable.setColumnSelectionAllowed(false);
        this.jTable.getTableHeader().setResizingAllowed(false);
        this.jTable.getTableHeader().setReorderingAllowed(false);
        this.jTextField = new JTextField();
        this.jTextField.setPreferredSize(new Dimension(50, 20));
        this.jTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    CalendarComponent.this.jScrollBar.setValue(Integer.parseInt(CalendarComponent.this.jTextField.getText()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.jComboBox = new JComboBox<String>(month);
        this.jComboBox.setPreferredSize(new Dimension(100, 20));
        this.jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CalendarComponent.this.update();
                CalendarComponent.this.buildTableData();
            }
        });
        this.jScrollBar = new JScrollBar(0);
        this.jScrollBar.setPreferredSize(new Dimension(25, 25));
        this.jScrollBar.setMinimum(1900);
        this.jScrollBar.setMaximum(9999);
        this.jScrollBar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                CalendarComponent.this.jTextField.setText("" + e.getValue());
                CalendarComponent.this.update();
                CalendarComponent.this.buildTableData();
            }
        });
        this.jPanel = new JPanel();
        this.jPanel.setSize(300, 100);
        this.jPanel.setLayout(new BorderLayout());
        this.jPanel.add((Component)this.jComboBox, "West");
        this.jPanel.add((Component)this.jTextField, "Center");
        this.jPanel.add((Component)this.jScrollBar, "East");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.jTable.setDefaultRenderer(clazz, new PlumMVCTableRenderer());
        this.jTable.setVisible(true);
        this.jTable.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    CalendarComponent.this.update();
                }
            }

            public void mousePressed(MouseEvent arg0) {
            }

            public void mouseReleased(MouseEvent arg0) {
            }

            public void mouseEntered(MouseEvent arg0) {
            }

            public void mouseExited(MouseEvent arg0) {
            }
        });
        this.jTable.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent e) {
                if (e.getKeyCode() == 32 || e.getKeyCode() == 10) {
                    CalendarComponent.this.update();
                }
            }

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.jPanel, "North");
        this.add((Component)new JScrollPane(this.jTable), "Center");
        this.setVisible(true);
        this.calendar = c;
        this.jScrollBar.setValue(this.calendar.get(1));
        this.jTextField.setText("" + this.jScrollBar.getValue());
        this.jComboBox.setSelectedIndex(this.calendar.get(2));
        this.buildTableData();
    }

    private void buildTableData() {
        this.tableData = new int[7][6];
        int firstDay = this.calendar.getActualMinimum(5);
        int endDay = this.calendar.getActualMaximum(5);
        Date copy = this.calendar.getTime();
        copy.setDate(firstDay);
        this.calendar.setTime(copy);
        int firstMonth = this.calendar.get(7);
        int i = firstDay;
        int j = firstMonth;
        int k = 0;
        while (i <= endDay) {
            copy = this.calendar.getTime();
            copy.setDate(i);
            this.calendar.setTime(copy);
            try {
                this.tableData[this.calendar.get((int)7) - 1][k] = i;
            }
            catch (Exception e) {
                System.out.println("ERROR:" + (this.calendar.get(7) - 1) + "/" + k);
            }
            if (j >= 7) {
                j = 0;
                ++k;
            }
            ++i;
            ++j;
        }
        this.jTable.setModel(new CalendarTableModel());
        this.jTable.setRowSelectionInterval(0, 0);
        this.jTable.setColumnSelectionInterval(firstMonth - 1, firstMonth - 1);
        this.jTable.updateUI();
        this.jTable.revalidate();
    }

    private void update() {
        Date oldDate = this.calendar.getTime();
        this.result = null;
        try {
            if (this.jTable.getSelectedColumn() < 0) {
                return;
            }
            if (this.jTable.getSelectedRow() < 0) {
                return;
            }
            if (this.jComboBox.getSelectedIndex() < 0) {
                return;
            }
            int year = Integer.parseInt(this.jTextField.getText().trim());
            int month = this.jComboBox.getSelectedIndex() + 1;
            int day = this.tableData[this.jTable.getSelectedColumn()][this.jTable.getSelectedRow()];
            if (day > 0) {
                this.calendar.setTime(new Date(String.valueOf(year) + "/" + month + "/" + day));
                this.result = Calendar.getInstance(Locale.JAPAN);
                this.result.setTime(new Date(String.valueOf(year) + "/" + month + "/" + day));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.calendar.setTime(oldDate);
        }
    }

    private class CalendarTableModel
    extends DefaultTableModel {
        private CalendarTableModel() {
        }

        public int getColumnCount() {
            return columns.length;
        }

        public String getColumnName(int col) {
            return columns[col];
        }

        public int getRowCount() {
            return 6;
        }

        public Object getValueAt(int row, int col) {
            if (CalendarComponent.this.tableData[col][row] == 0) {
                return "";
            }
            DecimalFormat df = new DecimalFormat("00");
            return df.format(CalendarComponent.this.tableData[col][row]);
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    class PlumMVCTableRenderer
    extends JLabel
    implements TableCellRenderer {
        public PlumMVCTableRenderer() {
            this.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            if (isSelected || hasFocus) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                super.setBackground(table.getBackground());
            }
            this.setHorizontalAlignment(0);
            this.setFont(table.getFont());
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }
}

