/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.beanbinder.petstore.test;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import jp.sf.beanbinder.petstore.model.Account;
import jp.sf.beanbinder.petstore.model.CreditCard;
import jp.sf.beanbinder.petstore.model.Item;
import jp.sf.beanbinder.petstore.model.ItemDetail;
import jp.sf.beanbinder.petstore.model.Order;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderTest
extends TestCase {
    public void testOrder() {
        Account account = new Account();
        account.setUserId("testusr");
        account.setPassword("pass123");
        Order order = new Order();
        order.setCustomer(account);
        order.setBillto(account);
        order.setShipto(account);
        order.setHandlingCharge(new BigDecimal(0));
        order.setShippingCharge(new BigDecimal(0));
        CreditCard card = new CreditCard();
        card.setName("visa");
        card.setCardNumber("0000 0000 0000 0000");
        card.setExpirationYear("2007");
        card.setExpirationMonth("12");
        order.setPaymentMethod(card);
        Item item = this.getItemList().get(0);
        order.addItemDetail(item, new BigDecimal(2));
        item = this.getItemList().get(1);
        order.addItemDetail(item, new BigDecimal(1));
        System.out.println("-------------------\u53d7\u6ce8\u66f8---------------------");
        for (ItemDetail itemDetail : order.getItemDetails()) {
            System.out.print(String.valueOf(itemDetail.getItem().getName()) + " / ");
            System.out.print("\u5358\u4fa1:" + itemDetail.getItem().getUnitPrice() + " / ");
            System.out.print("\u6570\u91cf:" + itemDetail.getQty().intValue() + " / ");
            System.out.print("\u91d1\u984d:" + itemDetail.getTotalPrice().intValue() + "\n");
        }
        System.out.print("\u9001\u6599:" + order.getShippingCharge().intValue() + "\n");
        System.out.print("\u624b\u6570\u6599:" + order.getHandlingCharge().intValue() + "\n");
        System.out.println("---------------------------------------------");
        System.out.print("\u5c0f\u8a08" + order.getTotalPrice().intValue() + "\n");
        System.out.print("\u6d88\u8cbb\u7a0e" + order.getTax().intValue() + "\n");
        System.out.print("\u8acb\u6c42\u984d" + order.getGross().intValue() + "\n");
        System.out.println("---------------------------------------------");
        OrderTest.assertEquals((int)order.getTotalPrice().intValue(), (int)3530);
        OrderTest.assertEquals((int)order.getTax().intValue(), (int)176);
        OrderTest.assertEquals((int)order.getGross().intValue(), (int)3706);
    }

    private List<Item> getItemList() {
        ArrayList<Item> list = new ArrayList<Item>();
        Item item = new Item();
        item.setName("\u30c6\u30b9\u30c8\u5546\u54c1");
        item.setUnitPrice(new BigDecimal(1500));
        list.add(item);
        item = new Item();
        item.setName("\u30c6\u30b9\u30c8\u5546\u54c12");
        item.setUnitPrice(new BigDecimal(530));
        list.add(item);
        return list;
    }
}

