/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.beanbinder.petstore.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import jp.sf.beanbinder.petstore.model.Account;
import jp.sf.beanbinder.petstore.model.Item;
import jp.sf.beanbinder.petstore.model.ItemDetail;
import jp.sf.beanbinder.petstore.model.PaymentMethod;
import jp.sf.beanbinder.petstore.model.Person;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Order
implements Serializable {
    private Long id;
    private Account customer;
    private Person billto;
    private Person shipto;
    private PaymentMethod paymentMethod;
    private BigDecimal taxRate = new BigDecimal(0.05);
    private BigDecimal handlingCharge = new BigDecimal(0);
    private BigDecimal shippingCharge = new BigDecimal(0);
    private List<ItemDetail> itemDetails = new ArrayList<ItemDetail>();

    public BigDecimal getTotalPrice() {
        BigDecimal subtotal = new BigDecimal(0);
        for (ItemDetail itemDetail : this.itemDetails) {
            subtotal = subtotal.add(itemDetail.getTotalPrice());
        }
        return subtotal;
    }

    public BigDecimal getTax() {
        return this.getTotalPrice().multiply(this.taxRate).setScale(0, 1);
    }

    public BigDecimal getGross() {
        BigDecimal gross = this.getTotalPrice().add(this.getTax());
        gross = gross.add(this.handlingCharge);
        gross = gross.add(this.shippingCharge);
        return gross;
    }

    public void addItemDetail(Item item, BigDecimal qty) {
        ItemDetail itemDetail = new ItemDetail();
        itemDetail.setItem(item);
        itemDetail.setQty(qty);
        this.getItemDetails().add(itemDetail);
    }

    public Person getBillto() {
        return this.billto;
    }

    public void setBillto(Person billto) {
        this.billto = billto;
    }

    public Account getCustomer() {
        return this.customer;
    }

    public void setCustomer(Account customer) {
        this.customer = customer;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<ItemDetail> getItemDetails() {
        return this.itemDetails;
    }

    public void setItemDetails(List<ItemDetail> itemDetails) {
        this.itemDetails = itemDetails;
    }

    public Person getShipto() {
        return this.shipto;
    }

    public void setShipto(Person shipto) {
        this.shipto = shipto;
    }

    public BigDecimal getTaxRate() {
        return this.taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getHandlingCharge() {
        return this.handlingCharge;
    }

    public void setHandlingCharge(BigDecimal handlingCharge) {
        this.handlingCharge = handlingCharge;
    }

    public BigDecimal getShippingCharge() {
        return this.shippingCharge;
    }

    public void setShippingCharge(BigDecimal shippingCharge) {
        this.shippingCharge = shippingCharge;
    }

    public PaymentMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(PaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
    }
}

